/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.generator.model;

import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.generator.annotation.Remark;
import cloud.agileframework.generator.model.BaseModel;
import cloud.agileframework.generator.properties.AnnotationType;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.Payload;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Builder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;
import org.hibernate.validator.constraints.Length;

public class ColumnModel
extends BaseModel {
    private String tableCat;
    private String bufferLength;
    private String tableName;
    private String columnDef;
    private String scopeCatalog;
    private String tableSchem;
    private String columnName;
    private String numPrecRadix;
    private String isAutoincrement;
    private String sqlDataType;
    private String scopeSchema;
    private String isPrimaryKey;
    private String dataType;
    private int columnSize;
    private String scopeTable;
    private String isNullable;
    private String nullable;
    private int decimalDigits;
    private String sqlDatetimeSub;
    private String isGeneratedcolumn;
    private String charOctetLength;
    private String ordinalPosition;
    private String sourceDataType;
    private String typeName;
    private String javaName;
    private String getMethod;
    private String setMethod;
    private Class<?> javaType;
    private String javaTypeName;
    private String javaSimpleTypeName;
    private String defValue;
    private final Set<String> fieldAnnotationDesc = Sets.newHashSet();

    public void build() {
        this.addAnnotation((Annotation)new Column(){

            public Class<? extends Annotation> annotationType() {
                return Column.class;
            }

            public String name() {
                return ColumnModel.this.getColumnName();
            }

            public boolean unique() {
                return false;
            }

            public boolean nullable() {
                return !"0".equals(ColumnModel.this.getNullable());
            }

            public boolean insertable() {
                return true;
            }

            public boolean updatable() {
                boolean update = "creatDate".equals(ColumnModel.this.javaName) || "creatTime".equals(ColumnModel.this.javaName) || "createTime".equals(ColumnModel.this.javaName) || "createDate".equals(ColumnModel.this.javaName);
                return !update;
            }

            public String columnDefinition() {
                if (!StringUtils.isEmpty((CharSequence)ColumnModel.this.getColumnDef())) {
                    return String.format("%s default %s", ColumnModel.this.getTypeName(), ColumnModel.this.getColumnDef());
                }
                return "";
            }

            public String table() {
                return "";
            }

            public int length() {
                if (ColumnModel.this.getColumnSize() > 0) {
                    return ColumnModel.this.getColumnSize();
                }
                return 255;
            }

            public int precision() {
                return 0;
            }

            public int scale() {
                return 0;
            }
        }, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
        if ("0".equals(this.nullable)) {
            if (this.javaType == String.class) {
                this.addAnnotation((Annotation)new NotBlank(){

                    public Class<? extends Annotation> annotationType() {
                        return NotBlank.class;
                    }

                    public String message() {
                        return Boolean.parseBoolean(ColumnModel.this.isPrimaryKey) ? "\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a" : BaseModel.toBlank(ColumnModel.this.getRemarks()) + "\u4e0d\u80fd\u4e3a\u7a7a";
                    }

                    public Class<?>[] groups() {
                        return new Class[0];
                    }

                    public Class<? extends Payload>[] payload() {
                        return new Class[0];
                    }
                }, AnnotationType.VALIDATE, (String desc) -> this.getAnnotationDesc().add((String)desc));
            } else {
                this.addAnnotation((Annotation)new NotNull(){

                    public Class<? extends Annotation> annotationType() {
                        return NotNull.class;
                    }

                    public String message() {
                        return Boolean.parseBoolean(ColumnModel.this.isPrimaryKey) ? "\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a" : BaseModel.toBlank(ColumnModel.this.getRemarks()) + "\u4e0d\u80fd\u4e3a\u7a7a";
                    }

                    public Class<?>[] groups() {
                        return new Class[0];
                    }

                    public Class<? extends Payload>[] payload() {
                        return new Class[0];
                    }
                }, AnnotationType.VALIDATE, (String desc) -> this.getAnnotationDesc().add((String)desc));
            }
        }
        if (this.columnSize > 0) {
            if (this.javaType == String.class) {
                this.addAnnotation((Annotation)new Length(){

                    public Class<? extends Annotation> annotationType() {
                        return Length.class;
                    }

                    public int min() {
                        return 0;
                    }

                    public int max() {
                        return ColumnModel.this.columnSize;
                    }

                    public String message() {
                        return "\u6700\u957f\u4e3a" + this.max() + "\u4e2a\u5b57\u7b26";
                    }

                    public Class<?>[] groups() {
                        return new Class[0];
                    }

                    public Class<? extends Payload>[] payload() {
                        return new Class[0];
                    }
                }, AnnotationType.VALIDATE, (String desc) -> this.getAnnotationDesc().add((String)desc));
            } else if (this.javaType == Integer.TYPE || this.javaType == Integer.class) {
                this.addAnnotation((Annotation)new Max(){

                    public Class<? extends Annotation> annotationType() {
                        return Max.class;
                    }

                    public String message() {
                        return "{javax.validation.constraints.Max.message}";
                    }

                    public Class<?>[] groups() {
                        return new Class[0];
                    }

                    public Class<? extends Payload>[] payload() {
                        return new Class[0];
                    }

                    public long value() {
                        return Integer.MAX_VALUE;
                    }
                }, AnnotationType.VALIDATE, (String desc) -> this.getAnnotationDesc().add((String)desc));
                this.addAnnotation((Annotation)new Min(){

                    public Class<? extends Annotation> annotationType() {
                        return Min.class;
                    }

                    public String message() {
                        return "{javax.validation.constraints.Min.message}";
                    }

                    public Class<?>[] groups() {
                        return new Class[0];
                    }

                    public Class<? extends Payload>[] payload() {
                        return new Class[0];
                    }

                    public long value() {
                        return 0L;
                    }
                }, AnnotationType.VALIDATE, (String desc) -> this.getAnnotationDesc().add((String)desc));
            } else if (this.javaType == Long.TYPE || this.javaType == Long.class) {
                this.addAnnotation((Annotation)new DecimalMax(){

                    public Class<? extends Annotation> annotationType() {
                        return DecimalMax.class;
                    }

                    public String message() {
                        return "{javax.validation.constraints.DecimalMax.message}";
                    }

                    public Class<?>[] groups() {
                        return new Class[0];
                    }

                    public Class<? extends Payload>[] payload() {
                        return new Class[0];
                    }

                    public String value() {
                        return Long.toString(Long.MAX_VALUE);
                    }

                    public boolean inclusive() {
                        return true;
                    }
                }, AnnotationType.VALIDATE, (String desc) -> this.getAnnotationDesc().add((String)desc));
                this.addAnnotation((Annotation)new DecimalMin(){

                    public Class<? extends Annotation> annotationType() {
                        return DecimalMin.class;
                    }

                    public String message() {
                        return "{javax.validation.constraints.DecimalMin.message}";
                    }

                    public Class<?>[] groups() {
                        return new Class[0];
                    }

                    public Class<? extends Payload>[] payload() {
                        return new Class[0];
                    }

                    public String value() {
                        return Long.toString(Long.MAX_VALUE);
                    }

                    public boolean inclusive() {
                        return true;
                    }
                }, AnnotationType.VALIDATE, (String desc) -> this.getAnnotationDesc().add((String)desc));
            }
        }
        if (Boolean.parseBoolean(this.isPrimaryKey)) {
            this.addAnnotation(Id.class, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
        } else if ("byte[]".equals(this.javaTypeName) || "java.sql.Blob".equals(this.javaTypeName) || "java.sql.Clob".equals(this.javaTypeName)) {
            if ("java.sql.Blob".equals(this.javaTypeName) || "java.sql.Clob".equals(this.javaTypeName)) {
                this.addAnnotation(Lob.class, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
            }
            this.addAnnotation((Annotation)new Basic(){

                public Class<? extends Annotation> annotationType() {
                    return Basic.class;
                }

                public FetchType fetch() {
                    return FetchType.LAZY;
                }

                public boolean optional() {
                    return true;
                }
            }, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
        } else {
            this.addAnnotation(Basic.class, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
        }
        this.addAnnotation(new Remark(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Remark.class;
            }

            @Override
            public String value() {
                return BaseModel.toBlank(ColumnModel.this.getRemarks());
            }
        }, AnnotationType.REMARK, (String desc) -> this.getFieldAnnotationDesc().add((String)desc));
        this.setMethod(this.javaName);
    }

    public void setColumnName(String columnName) {
        columnName = this.deleteHiddenCharacter(columnName);
        this.columnName = ColumnModel.getProperties().getKeywords().contains(columnName) ? String.format("`%s`", columnName) : columnName;
        this.javaName = ColumnModel.getProperties().isSensitive() ? StringUtil.toLowerName((String)columnName) : StringUtil.toLowerName((String)columnName.toLowerCase());
        this.javaName = this.javaName.replace("_", "");
        if ("updateTime".equals(this.javaName) || "updateDate".equals(this.javaName)) {
            this.addAnnotation((Annotation)new Temporal(){

                public Class<? extends Annotation> annotationType() {
                    return Temporal.class;
                }

                public TemporalType value() {
                    return TemporalType.TIMESTAMP;
                }
            }, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
            this.addAnnotation(UpdateTimestamp.class, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
        }
        if ("creatDate".equals(this.javaName) || "creatTime".equals(this.javaName) || "createTime".equals(this.javaName) || "createDate".equals(this.javaName)) {
            this.addAnnotation((Annotation)new Temporal(){

                public Class<? extends Annotation> annotationType() {
                    return Temporal.class;
                }

                public TemporalType value() {
                    return TemporalType.TIMESTAMP;
                }
            }, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
            this.addAnnotation(CreationTimestamp.class, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
        }
    }

    public void setTypeName(final String typeName) {
        this.typeName = typeName;
        if ("TIMESTAMP".equals(typeName) || "DATE".equals(typeName) || "TIME".equals(typeName)) {
            this.addAnnotation((Annotation)new Temporal(){

                public Class<? extends Annotation> annotationType() {
                    return Temporal.class;
                }

                public TemporalType value() {
                    return TemporalType.valueOf((String)typeName);
                }
            }, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
        }
        this.javaType = ColumnModel.getProperties().getJavaType(typeName.split("[\\s]+")[0].toLowerCase());
        if (this.javaType == null) {
            this.javaType = String.class;
        }
        this.javaTypeName = this.javaType.getName();
        this.javaSimpleTypeName = this.javaType.getSimpleName();
        this.setImport(this.javaType);
    }

    public void setIsPrimaryKey(String isPrimaryKey) {
        this.isPrimaryKey = isPrimaryKey;
    }

    private void setMethod(String name) {
        this.getMethod = Boolean.TYPE == this.javaType ? "is" + StringUtil.toUpperName((String)name) : "get" + StringUtil.toUpperName((String)name);
        this.setMethod = "set" + StringUtil.toUpperName((String)name);
    }

    public void setIsAutoincrement(String isAutoincrement) {
        this.isAutoincrement = isAutoincrement;
        if ("YES".equals(isAutoincrement)) {
            this.addAnnotation((Annotation)new GeneratedValue(){

                public Class<? extends Annotation> annotationType() {
                    return GeneratedValue.class;
                }

                public GenerationType strategy() {
                    return GenerationType.IDENTITY;
                }

                public String generator() {
                    return "";
                }
            }, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
        }
    }

    public void setColumnDef(String columnDef) {
        this.columnDef = this.deleteHiddenCharacter(columnDef);
        if (this.columnDef == null || "null".equalsIgnoreCase(columnDef)) {
            return;
        }
        if (Double.class == this.javaType) {
            this.defValue = NumberUtils.isCreatable((String)columnDef) ? Double.valueOf(columnDef).toString() : null;
        } else if (String.class == this.javaType || Character.TYPE == this.javaType) {
            this.defValue = String.format("\"%s\"", columnDef.replace("'", ""));
        } else if ("CURRENT_TIMESTAMP".equals(columnDef)) {
            if (java.util.Date.class == this.javaType || Date.class == this.javaType) {
                this.defValue = "new Date()";
            } else if (Time.class == this.javaType) {
                this.defValue = "new Time(System.currentTimeMillis())";
            } else if (Timestamp.class == this.javaType) {
                this.defValue = "new Timestamp(System.currentTimeMillis())";
            } else if (Long.TYPE == this.javaType) {
                this.defValue = "System.currentTimeMillis()";
            }
        }
        this.addAnnotation(Builder.class, AnnotationType.LOMBOK, (String desc) -> this.getAnnotationDesc().add((String)desc));
    }

    public String getTableCat() {
        return this.tableCat;
    }

    public String getBufferLength() {
        return this.bufferLength;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnDef() {
        return this.columnDef;
    }

    public String getScopeCatalog() {
        return this.scopeCatalog;
    }

    public String getTableSchem() {
        return this.tableSchem;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getNumPrecRadix() {
        return this.numPrecRadix;
    }

    public String getIsAutoincrement() {
        return this.isAutoincrement;
    }

    public String getSqlDataType() {
        return this.sqlDataType;
    }

    public String getScopeSchema() {
        return this.scopeSchema;
    }

    public String getIsPrimaryKey() {
        return this.isPrimaryKey;
    }

    public String getDataType() {
        return this.dataType;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public String getScopeTable() {
        return this.scopeTable;
    }

    public String getIsNullable() {
        return this.isNullable;
    }

    public String getNullable() {
        return this.nullable;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public String getSqlDatetimeSub() {
        return this.sqlDatetimeSub;
    }

    public String getIsGeneratedcolumn() {
        return this.isGeneratedcolumn;
    }

    public String getCharOctetLength() {
        return this.charOctetLength;
    }

    public String getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public String getSourceDataType() {
        return this.sourceDataType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public String getGetMethod() {
        return this.getMethod;
    }

    public String getSetMethod() {
        return this.setMethod;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public String getJavaTypeName() {
        return this.javaTypeName;
    }

    public String getJavaSimpleTypeName() {
        return this.javaSimpleTypeName;
    }

    public String getDefValue() {
        return this.defValue;
    }

    public Set<String> getFieldAnnotationDesc() {
        return this.fieldAnnotationDesc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnModel)) {
            return false;
        }
        ColumnModel other = (ColumnModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tableCat = this.getTableCat();
        String other$tableCat = other.getTableCat();
        if (this$tableCat == null ? other$tableCat != null : !this$tableCat.equals(other$tableCat)) {
            return false;
        }
        String this$bufferLength = this.getBufferLength();
        String other$bufferLength = other.getBufferLength();
        if (this$bufferLength == null ? other$bufferLength != null : !this$bufferLength.equals(other$bufferLength)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$columnDef = this.getColumnDef();
        String other$columnDef = other.getColumnDef();
        if (this$columnDef == null ? other$columnDef != null : !this$columnDef.equals(other$columnDef)) {
            return false;
        }
        String this$scopeCatalog = this.getScopeCatalog();
        String other$scopeCatalog = other.getScopeCatalog();
        if (this$scopeCatalog == null ? other$scopeCatalog != null : !this$scopeCatalog.equals(other$scopeCatalog)) {
            return false;
        }
        String this$tableSchem = this.getTableSchem();
        String other$tableSchem = other.getTableSchem();
        if (this$tableSchem == null ? other$tableSchem != null : !this$tableSchem.equals(other$tableSchem)) {
            return false;
        }
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
            return false;
        }
        String this$numPrecRadix = this.getNumPrecRadix();
        String other$numPrecRadix = other.getNumPrecRadix();
        if (this$numPrecRadix == null ? other$numPrecRadix != null : !this$numPrecRadix.equals(other$numPrecRadix)) {
            return false;
        }
        String this$isAutoincrement = this.getIsAutoincrement();
        String other$isAutoincrement = other.getIsAutoincrement();
        if (this$isAutoincrement == null ? other$isAutoincrement != null : !this$isAutoincrement.equals(other$isAutoincrement)) {
            return false;
        }
        String this$sqlDataType = this.getSqlDataType();
        String other$sqlDataType = other.getSqlDataType();
        if (this$sqlDataType == null ? other$sqlDataType != null : !this$sqlDataType.equals(other$sqlDataType)) {
            return false;
        }
        String this$scopeSchema = this.getScopeSchema();
        String other$scopeSchema = other.getScopeSchema();
        if (this$scopeSchema == null ? other$scopeSchema != null : !this$scopeSchema.equals(other$scopeSchema)) {
            return false;
        }
        String this$isPrimaryKey = this.getIsPrimaryKey();
        String other$isPrimaryKey = other.getIsPrimaryKey();
        if (this$isPrimaryKey == null ? other$isPrimaryKey != null : !this$isPrimaryKey.equals(other$isPrimaryKey)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        if (this.getColumnSize() != other.getColumnSize()) {
            return false;
        }
        String this$scopeTable = this.getScopeTable();
        String other$scopeTable = other.getScopeTable();
        if (this$scopeTable == null ? other$scopeTable != null : !this$scopeTable.equals(other$scopeTable)) {
            return false;
        }
        String this$isNullable = this.getIsNullable();
        String other$isNullable = other.getIsNullable();
        if (this$isNullable == null ? other$isNullable != null : !this$isNullable.equals(other$isNullable)) {
            return false;
        }
        String this$nullable = this.getNullable();
        String other$nullable = other.getNullable();
        if (this$nullable == null ? other$nullable != null : !this$nullable.equals(other$nullable)) {
            return false;
        }
        if (this.getDecimalDigits() != other.getDecimalDigits()) {
            return false;
        }
        String this$sqlDatetimeSub = this.getSqlDatetimeSub();
        String other$sqlDatetimeSub = other.getSqlDatetimeSub();
        if (this$sqlDatetimeSub == null ? other$sqlDatetimeSub != null : !this$sqlDatetimeSub.equals(other$sqlDatetimeSub)) {
            return false;
        }
        String this$isGeneratedcolumn = this.getIsGeneratedcolumn();
        String other$isGeneratedcolumn = other.getIsGeneratedcolumn();
        if (this$isGeneratedcolumn == null ? other$isGeneratedcolumn != null : !this$isGeneratedcolumn.equals(other$isGeneratedcolumn)) {
            return false;
        }
        String this$charOctetLength = this.getCharOctetLength();
        String other$charOctetLength = other.getCharOctetLength();
        if (this$charOctetLength == null ? other$charOctetLength != null : !this$charOctetLength.equals(other$charOctetLength)) {
            return false;
        }
        String this$ordinalPosition = this.getOrdinalPosition();
        String other$ordinalPosition = other.getOrdinalPosition();
        if (this$ordinalPosition == null ? other$ordinalPosition != null : !this$ordinalPosition.equals(other$ordinalPosition)) {
            return false;
        }
        String this$sourceDataType = this.getSourceDataType();
        String other$sourceDataType = other.getSourceDataType();
        if (this$sourceDataType == null ? other$sourceDataType != null : !this$sourceDataType.equals(other$sourceDataType)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$javaName = this.getJavaName();
        String other$javaName = other.getJavaName();
        if (this$javaName == null ? other$javaName != null : !this$javaName.equals(other$javaName)) {
            return false;
        }
        String this$getMethod = this.getGetMethod();
        String other$getMethod = other.getGetMethod();
        if (this$getMethod == null ? other$getMethod != null : !this$getMethod.equals(other$getMethod)) {
            return false;
        }
        String this$setMethod = this.getSetMethod();
        String other$setMethod = other.getSetMethod();
        if (this$setMethod == null ? other$setMethod != null : !this$setMethod.equals(other$setMethod)) {
            return false;
        }
        Class<?> this$javaType = this.getJavaType();
        Class<?> other$javaType = other.getJavaType();
        if (this$javaType == null ? other$javaType != null : !this$javaType.equals(other$javaType)) {
            return false;
        }
        String this$javaTypeName = this.getJavaTypeName();
        String other$javaTypeName = other.getJavaTypeName();
        if (this$javaTypeName == null ? other$javaTypeName != null : !this$javaTypeName.equals(other$javaTypeName)) {
            return false;
        }
        String this$javaSimpleTypeName = this.getJavaSimpleTypeName();
        String other$javaSimpleTypeName = other.getJavaSimpleTypeName();
        if (this$javaSimpleTypeName == null ? other$javaSimpleTypeName != null : !this$javaSimpleTypeName.equals(other$javaSimpleTypeName)) {
            return false;
        }
        String this$defValue = this.getDefValue();
        String other$defValue = other.getDefValue();
        if (this$defValue == null ? other$defValue != null : !this$defValue.equals(other$defValue)) {
            return false;
        }
        Set<String> this$fieldAnnotationDesc = this.getFieldAnnotationDesc();
        Set<String> other$fieldAnnotationDesc = other.getFieldAnnotationDesc();
        return !(this$fieldAnnotationDesc == null ? other$fieldAnnotationDesc != null : !((Object)this$fieldAnnotationDesc).equals(other$fieldAnnotationDesc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColumnModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tableCat = this.getTableCat();
        result = result * 59 + ($tableCat == null ? 43 : $tableCat.hashCode());
        String $bufferLength = this.getBufferLength();
        result = result * 59 + ($bufferLength == null ? 43 : $bufferLength.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $columnDef = this.getColumnDef();
        result = result * 59 + ($columnDef == null ? 43 : $columnDef.hashCode());
        String $scopeCatalog = this.getScopeCatalog();
        result = result * 59 + ($scopeCatalog == null ? 43 : $scopeCatalog.hashCode());
        String $tableSchem = this.getTableSchem();
        result = result * 59 + ($tableSchem == null ? 43 : $tableSchem.hashCode());
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        String $numPrecRadix = this.getNumPrecRadix();
        result = result * 59 + ($numPrecRadix == null ? 43 : $numPrecRadix.hashCode());
        String $isAutoincrement = this.getIsAutoincrement();
        result = result * 59 + ($isAutoincrement == null ? 43 : $isAutoincrement.hashCode());
        String $sqlDataType = this.getSqlDataType();
        result = result * 59 + ($sqlDataType == null ? 43 : $sqlDataType.hashCode());
        String $scopeSchema = this.getScopeSchema();
        result = result * 59 + ($scopeSchema == null ? 43 : $scopeSchema.hashCode());
        String $isPrimaryKey = this.getIsPrimaryKey();
        result = result * 59 + ($isPrimaryKey == null ? 43 : $isPrimaryKey.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        result = result * 59 + this.getColumnSize();
        String $scopeTable = this.getScopeTable();
        result = result * 59 + ($scopeTable == null ? 43 : $scopeTable.hashCode());
        String $isNullable = this.getIsNullable();
        result = result * 59 + ($isNullable == null ? 43 : $isNullable.hashCode());
        String $nullable = this.getNullable();
        result = result * 59 + ($nullable == null ? 43 : $nullable.hashCode());
        result = result * 59 + this.getDecimalDigits();
        String $sqlDatetimeSub = this.getSqlDatetimeSub();
        result = result * 59 + ($sqlDatetimeSub == null ? 43 : $sqlDatetimeSub.hashCode());
        String $isGeneratedcolumn = this.getIsGeneratedcolumn();
        result = result * 59 + ($isGeneratedcolumn == null ? 43 : $isGeneratedcolumn.hashCode());
        String $charOctetLength = this.getCharOctetLength();
        result = result * 59 + ($charOctetLength == null ? 43 : $charOctetLength.hashCode());
        String $ordinalPosition = this.getOrdinalPosition();
        result = result * 59 + ($ordinalPosition == null ? 43 : $ordinalPosition.hashCode());
        String $sourceDataType = this.getSourceDataType();
        result = result * 59 + ($sourceDataType == null ? 43 : $sourceDataType.hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $javaName = this.getJavaName();
        result = result * 59 + ($javaName == null ? 43 : $javaName.hashCode());
        String $getMethod = this.getGetMethod();
        result = result * 59 + ($getMethod == null ? 43 : $getMethod.hashCode());
        String $setMethod = this.getSetMethod();
        result = result * 59 + ($setMethod == null ? 43 : $setMethod.hashCode());
        Class<?> $javaType = this.getJavaType();
        result = result * 59 + ($javaType == null ? 43 : $javaType.hashCode());
        String $javaTypeName = this.getJavaTypeName();
        result = result * 59 + ($javaTypeName == null ? 43 : $javaTypeName.hashCode());
        String $javaSimpleTypeName = this.getJavaSimpleTypeName();
        result = result * 59 + ($javaSimpleTypeName == null ? 43 : $javaSimpleTypeName.hashCode());
        String $defValue = this.getDefValue();
        result = result * 59 + ($defValue == null ? 43 : $defValue.hashCode());
        Set<String> $fieldAnnotationDesc = this.getFieldAnnotationDesc();
        result = result * 59 + ($fieldAnnotationDesc == null ? 43 : ((Object)$fieldAnnotationDesc).hashCode());
        return result;
    }
}

