/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.generator;

import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.db.DataBaseUtil;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.common.util.properties.PropertiesUtil;
import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.generator.config.GeneratorConfig;
import cloud.agileframework.generator.model.TableModel;
import cloud.agileframework.generator.properties.GeneratorProperties;
import cloud.agileframework.generator.util.FreemarkerUtil;
import cloud.agileframework.spring.util.BeanUtil;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class AgileGenerator {
    private static final Logger logger = LoggerFactory.getLogger(AgileGenerator.class);
    private static final String ENTITY_FTL = "Entity.ftl";
    private static final String SERVICE_FTL = "Service.ftl";
    private static final String FILE_EXTENSION = ".java";
    private static DataSourceProperties dataSourceProperties;
    private static GeneratorProperties generator;

    static String getPackPath(String url) {
        String javaPath;
        url = AgileGenerator.parseUrl(url);
        String javaSourceUrl = AgileGenerator.parseUrl(generator.getJavaSourceUtl());
        if (StringUtil.isEmpty((CharSequence)javaSourceUrl) && !url.contains(javaPath = File.separator + "java" + File.separator)) {
            return null;
        }
        if ((url = url.substring(url.indexOf(javaSourceUrl) + javaSourceUrl.length())).length() > 0) {
            return url.substring(0, url.length() - 1).replaceAll(Matcher.quoteReplacement(File.separator), ".");
        }
        return null;
    }

    private static List<Map<String, Object>> getTableInfo() {
        return DataBaseUtil.listTables((String)dataSourceProperties.getUrl(), (String)dataSourceProperties.getUsername(), (String)dataSourceProperties.getPassword(), (String)generator.getTableName());
    }

    private static void initSpringContext() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        BeanUtil.setApplicationContext((ApplicationContext)context);
        StandardEnvironment environment = new StandardEnvironment();
        PropertiesPropertySource localPropertySource = new PropertiesPropertySource("localProperties", PropertiesUtil.getProperties());
        environment.getPropertySources().addLast((PropertySource)localPropertySource);
        context.setEnvironment((ConfigurableEnvironment)environment);
        context.register(new Class[]{GeneratorConfig.class});
        context.refresh();
        dataSourceProperties = (DataSourceProperties)BeanUtil.getBean(DataSourceProperties.class);
        generator = (GeneratorProperties)BeanUtil.getBean(GeneratorProperties.class);
    }

    private static String parseUrl(String str) {
        String url = str.replaceAll("[\\\\/]+", Matcher.quoteReplacement(File.separator));
        if (!url.endsWith(File.separator)) {
            url = url + File.separator;
        }
        return url;
    }

    private static void generateEntityFile(TableModel tableModel) throws IOException, TemplateException {
        String url = AgileGenerator.parseUrl(generator.getEntityUrl());
        String fileName = tableModel.getEntityName() + FILE_EXTENSION;
        tableModel.setEntityPackageName(AgileGenerator.getPackPath(url));
        FreemarkerUtil.generatorProxy(ENTITY_FTL, url, fileName, tableModel, false);
    }

    private static void generateServiceFile(TableModel tableModel) throws IOException, TemplateException {
        String url = AgileGenerator.parseUrl(generator.getServiceUrl());
        String fileName = tableModel.getServiceName() + FILE_EXTENSION;
        tableModel.setServicePackageName(AgileGenerator.getPackPath(url));
        FreemarkerUtil.generatorProxy(SERVICE_FTL, url, fileName, tableModel, false);
    }

    public static void init() {
        AgileGenerator.initSpringContext();
    }

    static void generator(TYPE type) throws IOException, TemplateException {
        List<Map<String, Object>> tables = AgileGenerator.getTableInfo();
        if (tables == null || tables.isEmpty()) {
            throw new RuntimeException("\u672a\u52a0\u8f7d\u5230\u4efb\u4f55\u6570\u636e\u5e93\u8868\u4fe1\u606f");
        }
        block4: for (Map<String, Object> table : tables) {
            TableModel tableModel = (TableModel)ObjectUtil.to(table, (TypeReference)new TypeReference<TableModel>(){});
            switch (type) {
                case ENTITY: {
                    AgileGenerator.generateEntityFile(tableModel);
                    continue block4;
                }
                case SERVICE: {
                    AgileGenerator.generateServiceFile(tableModel);
                    continue block4;
                }
            }
            AgileGenerator.generateEntityFile(tableModel);
            AgileGenerator.generateServiceFile(tableModel);
        }
    }

    public static void main(String[] args) {
        try {
            logger.info("\u30101\u3011\u5f00\u59cb\u751f\u6210\u6e90\u4ee3\u7801");
            AgileGenerator.init();
            logger.info("\u30102\u3011\u5b8c\u6210\u914d\u7f6e\u521d\u59cb\u5316\uff0c\u5f00\u59cb\u751f\u6210\u6587\u4ef6...");
            AgileGenerator.generator(TYPE.ENTITY);
            logger.info("\u30103\u3011\u5b8c\u6210\u6e90\u4ee3\u7801\u751f\u6210");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    static enum TYPE {
        ENTITY,
        SERVICE,
        DEFAULT;

    }
}

