/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.data.common.dao;

import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.data.common.dao.ColumnName;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TableWrapper<T> {
    private final T o;
    private final List<ColumnName> columns;
    private final String tableName;

    public TableWrapper(T o, Function<Class<T>, List<ColumnName>> toColumnNamesFunction, Function<Class<T>, String> toTableName) {
        this.o = o;
        Class<?> tClass = o.getClass();
        this.tableName = toTableName.apply(tClass);
        this.columns = toColumnNamesFunction.apply(tClass).stream().filter(c -> Arrays.stream(((AccessibleObject)((Object)c.getMember())).getAnnotations()).noneMatch(annotation -> "Transient".equals(annotation.annotationType().getSimpleName()))).collect(Collectors.toList());
        this.columns.stream().filter(f -> f.getMember() instanceof Field).forEach(f -> f.setValue(Optional.ofNullable(ObjectUtil.getFieldValue((Object)o, (Field)((Field)f.getMember())))));
        this.columns.stream().filter(f -> f.getMember() instanceof Method).forEach(f -> {
            try {
                Method method = (Method)f.getMember();
                method.setAccessible(true);
                f.setValue(Optional.ofNullable(method.invoke(o, new Object[0])));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
            f.setValue(Optional.empty());
        });
    }

    public T getO() {
        return this.o;
    }

    public List<ColumnName> getColumns() {
        return this.columns;
    }

    public String getTableName() {
        return this.tableName;
    }
}

