/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.data.common.dao;

import cloud.agileframework.common.util.number.NumberUtil;
import cloud.agileframework.common.util.string.StringUtil;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLTimestampExpr;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;

public class ColumnName {
    private String name;
    private Member member;
    private Optional<Object> value;
    private boolean primaryKey;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Member getMember() {
        return this.member;
    }

    public void setMember(Member member) {
        this.member = member;
        if (this.name != null) {
            return;
        }
        if (member instanceof Field) {
            this.name = member.getName();
        }
        if (member instanceof Method && member.getName().startsWith("get")) {
            this.name = StringUtil.toLowerName((String)this.name.substring(3));
        }
        if (member instanceof Method && member.getName().startsWith("is") && ((Method)member).getReturnType() == Boolean.class) {
            this.name = StringUtil.toLowerName((String)this.name.substring(2));
        }
    }

    public Optional<Object> getValue() {
        return this.value;
    }

    public void setValue(Optional<Object> value) {
        this.value = value;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public SQLBinaryOpExpr sql(DbType dbType) {
        Object v = this.getValue().orElse(null);
        if (v == null) {
            return new SQLBinaryOpExpr(SQLUtils.toSQLExpr((String)this.getName(), (DbType)dbType), SQLBinaryOperator.Is, SQLUtils.toSQLExpr(null, (DbType)dbType));
        }
        SQLExpr right = this.sqlValue();
        return new SQLBinaryOpExpr(SQLUtils.toSQLExpr((String)this.getName()), SQLBinaryOperator.Equality, right);
    }

    public SQLExpr sqlValue() {
        Object v = this.getValue().orElse(null);
        if (v == null) {
            return null;
        }
        Object right = NumberUtil.isNumber(v.getClass()) || v instanceof Boolean ? SQLUtils.toSQLExpr((String)Objects.toString(v)) : (v instanceof Date ? new SQLTimestampExpr((Date)v, TimeZone.getDefault()) : SQLUtils.toSQLExpr((String)String.format("'%s'", v)));
        return right;
    }
}

