/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.data.common.dao;

import cloud.agileframework.common.DataException;
import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.data.common.dao.ColumnName;
import cloud.agileframework.data.common.dao.TableWrapper;
import cloud.agileframework.data.common.dictionary.DataExtendManager;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.PagerUtils;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.annotation.Id;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.PagingAndSortingRepository;

public interface BaseDao {
    public static final Map<Class<?>, PagingAndSortingRepository> REPOSITORY_CACHE = new HashMap();

    public DataExtendManager dictionaryManager();

    public <T, ID> PagingAndSortingRepository<T, ID> getRepository(Class<T> var1);

    default public <T> void save(T o) {
        if (o instanceof Class) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter must be of type POJO"));
        }
        this.saveAndReturn(o);
    }

    default public <T> boolean save(Iterable<T> list) {
        boolean isTrue = false;
        Iterator<T> iterator = list.iterator();
        if (iterator.hasNext()) {
            T obj = iterator.next();
            Class<?> tClass = obj.getClass();
            this.getRepository(tClass).saveAll(list);
            isTrue = true;
        }
        return isTrue;
    }

    public Connection getConnection() throws SQLException;

    default public <T> boolean contains(T o) {
        if (o instanceof Class) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter must be of type POJO"));
        }
        Class<?> aClass = o.getClass();
        PagingAndSortingRepository r = this.getRepository(aClass);
        Object id = this.getId(o);
        return r.existsById(id);
    }

    default public <T> T saveOrUpdate(T o) {
        if (o instanceof Class) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter must be of type POJO"));
        }
        Object id = this.getId(o);
        if (this.existsById(o.getClass(), id)) {
            this.deleteById(o.getClass(), id);
            return this.saveAndReturn(o, true);
        }
        return this.saveAndReturn(o);
    }

    default public <T> T saveAndReturn(T o, boolean isFlush) {
        if (o instanceof Class) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter must be of type POJO"));
        }
        Class<?> aClass = o.getClass();
        PagingAndSortingRepository r = this.getRepository(aClass);
        Object newObject = r.save(o);
        this.dictionaryManager().cover(newObject);
        return (T)newObject;
    }

    default public <T> T saveAndReturn(T o) {
        if (o instanceof Class) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter must be of type POJO"));
        }
        return this.saveAndReturn(o, Boolean.FALSE);
    }

    default public <T> List<T> saveAndReturn(Iterable<T> list) {
        Iterator<T> iterator = list.iterator();
        if (iterator.hasNext()) {
            T obj = iterator.next();
            Class<?> clazz = obj.getClass();
            return Lists.newArrayList((Iterable)this.getRepository(clazz).saveAll(list));
        }
        return new ArrayList(0);
    }

    default public <T> boolean existsById(Class<T> tableClass, Object id) {
        PagingAndSortingRepository r = this.getRepository(tableClass);
        return r.existsById(this.toIdType(tableClass, id));
    }

    default public <T> boolean update(T o) {
        Object id;
        if (o instanceof Class) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter must be of type POJO"));
        }
        Class<?> aClass = o.getClass();
        if (this.existsById(aClass, id = this.getId(o))) {
            this.deleteById(aClass, id);
            this.saveAndReturn(o, true);
            return true;
        }
        return false;
    }

    default public <T> T updateOfNotNull(T o) {
        Object id;
        if (o instanceof Class) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter must be of type POJO"));
        }
        Class<?> aClass = o.getClass();
        if (this.existsById(aClass, id = this.getId(o))) {
            Object old = this.findOne(aClass, id);
            ObjectUtil.copyProperties(old, o, (ObjectUtil.Compare)ObjectUtil.Compare.DIFF_TARGET_NULL);
            this.deleteById(aClass, id);
            return this.saveAndReturn(o, true);
        }
        return null;
    }

    default public <T> void delete(T o) {
        if (o instanceof Class) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter must be of type POJO"));
        }
        Class<?> aClass = o.getClass();
        this.getRepository(aClass).delete(o);
    }

    default public <T> boolean deleteById(Class<T> tableClass, Object id) {
        PagingAndSortingRepository repository = this.getRepository(tableClass);
        try {
            repository.deleteById(this.toIdType(tableClass, id));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    default public <T> void deleteAll(Class<T> tableClass) {
        this.getRepository(tableClass).deleteAll();
    }

    default public <T> void deleteAllInBatch(Class<T> tableClass) {
        this.deleteAll(tableClass);
    }

    default public <T> void deleteInBatch(Class<T> tableClass, Object[] ids) {
        this.deleteInBatch(tableClass, Sets.newHashSet((Object[])ids));
    }

    default public <T> void deleteInBatch(Class<T> tableClass, Iterable<?> ids) {
        if (ids == null) {
            return;
        }
        PagingAndSortingRepository repository = this.getRepository(tableClass);
        HashSet set = Sets.newHashSet();
        for (Object id : ids) {
            set.add(this.toIdType(tableClass, id));
        }
        repository.deleteAllById((Iterable)set);
    }

    default public <T> void deleteInBatch(Iterable<T> list) {
        if (Iterables.isEmpty(list)) {
            return;
        }
        PagingAndSortingRepository repository = this.getRepository(list.iterator().next().getClass());
        repository.deleteAll(list);
    }

    default public <T> T findOne(Class<T> clazz, Object id) {
        PagingAndSortingRepository repository = this.getRepository(clazz);
        T newObject = repository.findById(id).orElse(null);
        this.dictionaryManager().cover(newObject);
        return newObject;
    }

    default public <T> T findOne(T object) {
        if (object instanceof Class) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter must be of type POJO"));
        }
        PagingAndSortingRepository repository = this.getRepository(object.getClass());
        T newObject = repository.findById(this.getId(object)).orElse(null);
        this.dictionaryManager().cover(newObject);
        return newObject;
    }

    default public Map<String, Object> findOne(String sql, Object ... parameters) {
        return this.findBySQL(sql, parameters).stream().findFirst().orElse(null);
    }

    default public <T> T findOne(String sql, Class<T> clazz, Object ... parameters) {
        T newObject = this.findBySQL(sql, clazz, parameters).stream().findFirst().orElse(null);
        this.dictionaryManager().cover(newObject);
        return newObject;
    }

    default public <T> List<T> findAll(T object) {
        if (object instanceof Class) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter must be of type POJO"));
        }
        List<?> content = this.findBySQL(this.toSelectSql(object, Sort.unsorted(), DbType.mysql), object.getClass(), null);
        this.dictionaryManager().cover(content);
        return content;
    }

    default public <T> List<T> findAll(T object, Sort sort) {
        if (object instanceof Class) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter must be of type POJO"));
        }
        List<?> content = this.findBySQL(this.toSelectSql(object, sort, DbType.mysql), object.getClass(), null);
        this.dictionaryManager().cover(content);
        return content;
    }

    default public <T> Page<T> page(T object, int page, int size) {
        if (object instanceof Class) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter must be of type POJO"));
        }
        return this.page(object, page, size, Sort.unsorted());
    }

    default public <T> Page<T> page(T object, int page, int size, Sort sort) {
        if (object instanceof Class) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter must be of type POJO"));
        }
        return this.page(object, PageRequest.of((int)page, (int)size, (Sort)sort));
    }

    public <T> Page<T> page(T var1, PageRequest var2);

    default public <T> Page<T> pageByClass(Class<T> tableClass, PageRequest pageRequest) {
        Page pageInfo = this.getRepository(tableClass).findAll((Pageable)pageRequest);
        this.dictionaryManager().cover(pageInfo.getContent());
        return pageInfo;
    }

    default public <T> Page<T> pageByClass(Class<T> tableClass, int page, int size) {
        return this.pageByClass(tableClass, PageRequest.of((int)(page - 1), (int)size));
    }

    default public Page<Map<String, Object>> pageBySQL(String sql, PageRequest pageable, Object ... parameters) {
        return this.pageBySQL(sql, pageable, null, parameters);
    }

    public <T> Page<T> pageBySQL(String var1, PageRequest var2, Class<T> var3, Object ... var4);

    default public <T> Page<T> pageBySQL(String sql, int page, int size, Class<T> clazz, Object ... parameters) {
        return this.pageBySQL(sql, PageRequest.of((int)(page - 1), (int)size, (Sort)Sort.unsorted()), clazz, parameters);
    }

    default public Page<Map<String, Object>> pageBySQL(String sql, int page, int size, Object ... parameters) {
        return this.pageBySQL(sql, PageRequest.of((int)(page - 1), (int)size, (Sort)Sort.unsorted()), parameters);
    }

    default public <T> List<T> findAllByClass(Class<T> tableClass) {
        Iterable list = this.getRepository(tableClass).findAll();
        this.dictionaryManager().cover(list);
        return Lists.newArrayList((Iterable)list);
    }

    default public <T> List<T> findAllByClass(Class<T> tableClass, Sort sort) {
        Iterable list = this.getRepository(tableClass).findAll(sort);
        this.dictionaryManager().cover(list);
        return Lists.newArrayList((Iterable)list);
    }

    public <T> List<T> findBySQL(String var1, Class<T> var2, Object ... var3);

    public <T> List<T> findBySQL(String var1, Class<T> var2, Integer var3, Integer var4, Object ... var5);

    public List<Map<String, Object>> findBySQL(String var1, Object ... var2);

    public int updateBySQL(String var1, Object ... var2);

    default public <T> List<T> findAllById(Class<T> tableClass, Iterable<Object> ids) {
        Iterable list = this.getRepository(tableClass).findAllById(ids);
        this.dictionaryManager().cover(list);
        return Lists.newArrayList((Iterable)list);
    }

    default public <T> List<T> findAllByArrayId(Class<T> tableClass, Object ... ids) {
        Iterable list = this.getRepository(tableClass).findAllById((Iterable)Sets.newHashSet((Object[])ids));
        this.dictionaryManager().cover(list);
        return Lists.newArrayList((Iterable)list);
    }

    default public long count(Class<?> tableClass) {
        return this.getRepository(tableClass).count();
    }

    default public <T> void batchInsert(List<T> list) {
        this.batchInsert(list, 1000);
    }

    default public <T> void batchUpdate(List<T> list) {
        this.batchUpdate(list, 1000);
    }

    default public <T> void batchDelete(List<T> list) {
        this.batchDelete(list, 1000);
    }

    default public <T> void batchInsert(List<T> list, int batchSize) {
        this.save((Iterable<T>)list);
    }

    default public <T> void batchUpdate(List<T> list, int batchSize) {
        for (T o : list) {
            this.update(o);
        }
    }

    default public <T> void batchDelete(List<T> list, int batchSize) {
        PagingAndSortingRepository re = this.getRepository(list.iterator().next().getClass());
        re.deleteAll(list);
    }

    default public Field getIdField(Class<?> clazz) {
        Set e = ClassUtil.getAllEntityAnnotation(clazz, Id.class);
        Member member = ((ClassUtil.Target)e.iterator().next()).getMember();
        if (member instanceof Field) {
            return (Field)member;
        }
        String methodName = member.getName();
        if (methodName.startsWith("get")) {
            return ClassUtil.getField(clazz, (String)methodName.substring(3));
        }
        throw new DataException((Throwable)new NoSuchFieldException("\u6ca1\u627e\u5230\u4e3b\u952e\u5b57\u6bb5"));
    }

    default public Object getId(Object o) {
        try {
            return this.getIdField(o.getClass()).get(o);
        }
        catch (IllegalAccessException e) {
            throw new DataException((Throwable)e);
        }
    }

    default public void setId(Object o, Object id) {
        try {
            Field idField = this.getIdField(o.getClass());
            idField.setAccessible(true);
            idField.set(o, ObjectUtil.to((Object)id, (TypeReference)new TypeReference(idField.getType())));
        }
        catch (IllegalAccessException e) {
            throw new DataException((Throwable)e);
        }
    }

    default public Class<?> getIdType(Class<?> clazz) {
        return this.getIdField(clazz).getType();
    }

    default public Object toIdType(Class<?> clazz, Object id) {
        return ObjectUtil.to((Object)id, (TypeReference)new TypeReference(this.getIdType(clazz)));
    }

    default public <T> String toSelectSql(T o, Sort sort, DbType dbType) {
        if (o instanceof Class || o == null) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter must be of type POJO"));
        }
        TableWrapper<T> tableWrapper = new TableWrapper<T>(o, this::toColumnNames, this::toTableName);
        SQLSelectQueryBlock query = new SQLSelectQueryBlock();
        query.setFrom((SQLTableSource)new SQLExprTableSource(tableWrapper.getTableName()));
        tableWrapper.getColumns().stream().map(ColumnName::getName).forEach(e -> query.addSelectItem(new SQLSelectItem(SQLUtils.toSQLExpr((String)e))));
        tableWrapper.getColumns().stream().filter(e -> e.getValue().isPresent()).map(e -> e.sql(dbType)).reduce((a, b) -> new SQLBinaryOpExpr((SQLExpr)a, SQLBinaryOperator.BooleanAnd, (SQLExpr)b)).ifPresent(arg_0 -> ((SQLSelectQueryBlock)query).setWhere(arg_0));
        sort.stream().forEach(s -> query.addOrderBy(new SQLOrderBy(SQLUtils.toSQLExpr((String)s.getProperty()), s.getDirection().isAscending() ? SQLOrderingSpecification.ASC : SQLOrderingSpecification.DESC)));
        return SQLUtils.toSQLString((SQLObject)query, (DbType)dbType);
    }

    default public <T> String toUpdateSql(T o, DbType dbType) {
        if (o instanceof Class || o == null) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter must be of type POJO"));
        }
        TableWrapper<T> tableWrapper = new TableWrapper<T>(o, this::toColumnNames, this::toTableName);
        SQLUpdateStatement update = new SQLUpdateStatement();
        update.setTableSource((SQLTableSource)new SQLExprTableSource(tableWrapper.getTableName()));
        tableWrapper.getColumns().stream().filter(ColumnName::isPrimaryKey).filter(e -> e.getValue().isPresent()).map(e -> e.sql(dbType)).reduce((a, b) -> new SQLBinaryOpExpr((SQLExpr)a, SQLBinaryOperator.BooleanAnd, (SQLExpr)b)).ifPresent(arg_0 -> ((SQLUpdateStatement)update).setWhere(arg_0));
        tableWrapper.getColumns().stream().filter(e -> !e.isPrimaryKey()).filter(e -> e.getValue().isPresent()).forEach(f -> {
            SQLUpdateSetItem updateSetItem = new SQLUpdateSetItem();
            updateSetItem.setColumn(SQLUtils.toSQLExpr((String)f.getName(), (DbType)dbType));
            updateSetItem.setValue(f.sqlValue());
            update.addItem(updateSetItem);
        });
        return SQLUtils.toSQLString((SQLObject)update, (DbType)dbType);
    }

    default public <T> String toInsertSql(T o, DbType dbType) {
        if (o instanceof Class || o == null) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter must be of type POJO"));
        }
        TableWrapper<T> tableWrapper = new TableWrapper<T>(o, this::toColumnNames, this::toTableName);
        SQLInsertStatement insert = new SQLInsertStatement();
        insert.setTableSource(new SQLExprTableSource(tableWrapper.getTableName()));
        SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause();
        tableWrapper.getColumns().stream().filter(e -> e.getValue().isPresent()).forEach(f -> {
            insert.addColumn(SQLUtils.toSQLExpr((String)f.getName(), (DbType)dbType));
            values.addValue(f.sqlValue());
        });
        insert.addValueCause(values);
        return SQLUtils.toSQLString((SQLObject)insert, (DbType)dbType);
    }

    default public <T> String toInsertSql(List<T> list, DbType dbType) {
        if (list == null || list.isEmpty()) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter contains at least one element"));
        }
        List<TableWrapper> rows = list.stream().map(c -> new TableWrapper<Object>(c, this::toColumnNames, this::toTableName)).collect(Collectors.toList());
        SQLInsertStatement insert = new SQLInsertStatement();
        rows.forEach(row -> {
            if (insert.getTableName() == null) {
                insert.setTableSource(new SQLExprTableSource(row.getTableName()));
                SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause();
                row.getColumns().stream().filter(e -> e.getValue().isPresent()).forEach(f -> {
                    insert.addColumn(SQLUtils.toSQLExpr((String)f.getName(), (DbType)dbType));
                    values.addValue(f.sqlValue());
                });
                insert.addValueCause(values);
            }
        });
        return SQLUtils.toSQLString((SQLObject)insert, (DbType)dbType);
    }

    default public <T> String toDeleteSql(T o, DbType dbType) {
        if (o instanceof Class || o == null) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter must be of type POJO"));
        }
        TableWrapper<T> tableWrapper = new TableWrapper<T>(o, this::toColumnNames, this::toTableName);
        SQLDeleteStatement delete = new SQLDeleteStatement();
        delete.setTableSource((SQLTableSource)new SQLExprTableSource(tableWrapper.getTableName()));
        tableWrapper.getColumns().stream().filter(e -> e.getValue().isPresent()).map(e -> e.sql(dbType)).reduce((a, b) -> new SQLBinaryOpExpr((SQLExpr)a, SQLBinaryOperator.BooleanAnd, (SQLExpr)b)).ifPresent(arg_0 -> ((SQLDeleteStatement)delete).setWhere(arg_0));
        return SQLUtils.toSQLString((SQLObject)delete, (DbType)dbType);
    }

    public <T> List<ColumnName> toColumnNames(Class<T> var1);

    public <T> String toTableName(Class<T> var1);

    default public <T> String toPageSQL(T o, PageRequest pageRequest, DbType dbType) {
        if (o instanceof Class) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter must be of type POJO"));
        }
        String select = this.toSelectSql(o, pageRequest.getSort(), dbType);
        int pageSize = pageRequest.getPageSize();
        int pageNumber = pageRequest.getPageNumber();
        return PagerUtils.limit((String)select, (DbType)DbType.mysql, (int)(pageNumber * pageSize), (int)pageSize);
    }

    default public <T> String toPageCountSQL(T o, PageRequest pageRequest, DbType dbType) {
        if (o instanceof Class) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter must be of type POJO"));
        }
        String select = this.toSelectSql(o, pageRequest.getSort(), dbType);
        return PagerUtils.count((String)select, (DbType)DbType.mysql);
    }

    default public <T> Map<String, Optional<Object>> toColumnValueMapping(T o) {
        if (o instanceof Class || o == null) {
            throw new DataException((Throwable)new IllegalArgumentException("Parameter must be of type POJO"));
        }
        Class<?> tableClass = o.getClass();
        Set fields = this.toColumnNames(tableClass).stream().filter(c -> Arrays.stream(((AccessibleObject)((Object)c.getMember())).getAnnotations()).noneMatch(annotation -> "Transient".equals(annotation.annotationType().getSimpleName()))).collect(Collectors.toSet());
        Map<String, Optional<Object>> map = fields.stream().filter(f -> f.getMember() instanceof Field).collect(Collectors.toMap(ColumnName::getName, f -> Optional.ofNullable(ObjectUtil.getFieldValue((Object)o, (Field)((Field)f.getMember())))));
        Map<String, Optional> map2 = fields.stream().filter(f -> f.getMember() instanceof Method).collect(Collectors.toMap(ColumnName::getName, f -> {
            try {
                Method method = (Method)f.getMember();
                method.setAccessible(true);
                return Optional.ofNullable(method.invoke(o, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }));
        map.putAll(map2);
        return map;
    }

    public static class ColumnValueMapping {
        private ColumnName column;
        private String value;
    }
}

