/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.data.common.auth;

import cloud.agileframework.common.util.json.JSONUtil;
import cloud.agileframework.common.util.template.VelocityUtil;
import cloud.agileframework.data.common.auth.AuthDataProperties;
import cloud.agileframework.data.common.auth.annotation.AuthData;
import cloud.agileframework.spring.util.SecurityUtil;
import cloud.agileframework.sql.SqlUtil;
import com.alibaba.druid.filter.FilterChain;
import com.alibaba.druid.filter.FilterEventAdapter;
import com.alibaba.druid.proxy.jdbc.CallableStatementProxy;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.proxy.jdbc.PreparedStatementProxy;
import com.alibaba.druid.proxy.jdbc.ResultSetProxy;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.fastjson2.JSONObject;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.userdetails.UserDetails;

public class AuthFilter
extends FilterEventAdapter {
    private final Map<String, String> filterMapping;
    private final ThreadLocal<AuthData> config = new ThreadLocal();

    public void setConfig(AuthData config) {
        this.config.set(config);
    }

    public void clear() {
        this.config.remove();
    }

    public AuthFilter(AuthDataProperties authDataProperties) {
        this.filterMapping = authDataProperties.getFilterMapping();
    }

    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        return super.statement_execute(chain, statement, this.parseSql(sql));
    }

    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql, int autoGeneratedKeys) throws SQLException {
        return super.statement_execute(chain, statement, this.parseSql(sql), autoGeneratedKeys);
    }

    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql, int[] columnIndexes) throws SQLException {
        return super.statement_execute(chain, statement, this.parseSql(sql), columnIndexes);
    }

    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql, String[] columnNames) throws SQLException {
        return super.statement_execute(chain, statement, this.parseSql(sql), columnNames);
    }

    public int[] statement_executeBatch(FilterChain chain, StatementProxy statement) throws SQLException {
        List batch = statement.getBatchSqlList().stream().map(this::parseSql).collect(Collectors.toList());
        statement.clearBatch();
        for (String sql : batch) {
            statement.addBatch(sql);
        }
        return super.statement_executeBatch(chain, statement);
    }

    public ResultSetProxy statement_executeQuery(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        return super.statement_executeQuery(chain, statement, this.parseSql(sql));
    }

    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql) throws SQLException {
        return super.connection_prepareCall(chain, connection, this.parseSql(sql));
    }

    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int autoGeneratedKeys) throws SQLException {
        return super.connection_prepareStatement(chain, connection, this.parseSql(sql), autoGeneratedKeys);
    }

    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return super.connection_prepareStatement(chain, connection, this.parseSql(sql), resultSetType, resultSetConcurrency);
    }

    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return super.connection_prepareStatement(chain, connection, this.parseSql(sql), resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int[] columnIndexes) throws SQLException {
        return super.connection_prepareStatement(chain, connection, this.parseSql(sql), columnIndexes);
    }

    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, String[] columnNames) throws SQLException {
        return super.connection_prepareStatement(chain, connection, this.parseSql(sql), columnNames);
    }

    public CallableStatementProxy connection_prepareCall(FilterChain chain, ConnectionProxy connection, String sql) throws SQLException {
        return super.connection_prepareCall(chain, connection, this.parseSql(sql));
    }

    public CallableStatementProxy connection_prepareCall(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return super.connection_prepareCall(chain, connection, this.parseSql(sql), resultSetType, resultSetConcurrency);
    }

    public CallableStatementProxy connection_prepareCall(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return super.connection_prepareCall(chain, connection, this.parseSql(sql), resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    private String parseSql(String sql) {
        AuthData authData;
        block14: {
            block13: {
                authData = this.config.get();
                if (authData == null || Boolean.FALSE.equals(authData.enable()) || this.filterMapping == null || this.filterMapping.isEmpty()) break block13;
                if (!this.filterMapping.keySet().stream().noneMatch(sql::contains)) break block14;
            }
            return sql;
        }
        try {
            SQLStatement sqlStatement;
            UserDetails userDetails = SecurityUtil.currentUser();
            if (authData.group().length > 0) {
                JSONObject jsonObject = (JSONObject)JSONUtil.toJSON((Object)userDetails);
                jsonObject.put((Object)"AUTH_GROUP", (Object)authData.group());
            }
            if ((sqlStatement = SQLUtils.parseSingleMysqlStatement((String)sql)) instanceof SQLSelectStatement) {
                this.parsing(((SQLSelectStatement)sqlStatement).getSelect(), authData);
            } else if (sqlStatement instanceof SQLSubqueryTableSource) {
                this.parsing(((SQLSubqueryTableSource)sqlStatement).getSelect(), authData);
            } else if (sqlStatement instanceof SQLUnionQueryTableSource) {
                this.parsing((SQLSelectQuery)((SQLUnionQueryTableSource)sqlStatement).getUnion(), authData);
            } else if (sqlStatement instanceof SQLJoinTableSource) {
                this.parsing(((SQLJoinTableSource)sqlStatement).getLeft(), authData);
                this.parsing(((SQLJoinTableSource)sqlStatement).getRight(), authData);
            }
            return SqlUtil.parserSQL((String)SQLUtils.toSQLString((SQLObject)sqlStatement), (Object)userDetails);
        }
        catch (Exception e) {
            return sql;
        }
    }

    private void parsing(SQLSelectQuery sqlSelectQuery, AuthData authData) {
        if (sqlSelectQuery instanceof SQLSelectQueryBlock) {
            this.parsing(((SQLSelectQueryBlock)sqlSelectQuery).getFrom(), authData);
        } else if (sqlSelectQuery instanceof SQLUnionQuery) {
            for (SQLSelectQuery sqlSelectQuery2 : ((SQLUnionQuery)sqlSelectQuery).getChildren()) {
                this.parsing(sqlSelectQuery2, authData);
            }
        }
    }

    private void parsing(SQLSelect select, AuthData authData) {
        this.parsing((SQLSelectQuery)select.getQueryBlock(), authData);
    }

    private void parsing(SQLTableSource table, AuthData authData) {
        block8: {
            block7: {
                SQLExpr sql;
                String alias;
                block9: {
                    if (!(table instanceof SQLExprTableSource)) break block7;
                    String tableProxy = this.filterMapping.get(((SQLExprTableSource)table).getTableName());
                    if (StringUtils.isBlank((CharSequence)tableProxy)) break block8;
                    UserDetails userDetails = SecurityUtil.currentUser();
                    JSONObject jsonObject = (JSONObject)JSONUtil.toJSON((Object)userDetails);
                    if (authData.group().length > 0) {
                        jsonObject.put((Object)"AUTH_GROUP", (Object)authData.group());
                    }
                    tableProxy = VelocityUtil.parse((String)tableProxy, (Object)jsonObject);
                    alias = table.getAlias();
                    alias = alias == null ? "SUB_ALIAS" : alias;
                    sql = SQLUtils.toSQLExpr((String)tableProxy);
                    if (!(sql instanceof SQLQueryExpr)) break block9;
                    SQLUtils.replaceInParent((SQLTableSource)table, (SQLTableSource)new SQLSubqueryTableSource(((SQLQueryExpr)sql).getSubQuery(), alias));
                    break block8;
                }
                if (!(sql instanceof SQLIdentifierExpr)) break block8;
                SQLUtils.replaceInParent((SQLTableSource)table, (SQLTableSource)new SQLExprTableSource(sql, alias));
                break block8;
            }
            if (table instanceof SQLJoinTableSource) {
                this.parsing(((SQLJoinTableSource)table).getLeft(), authData);
                this.parsing(((SQLJoinTableSource)table).getRight(), authData);
            } else if (table instanceof SQLSubqueryTableSource) {
                this.parsing(((SQLSubqueryTableSource)table).getSelect(), authData);
            } else if (table instanceof SQLUnionQueryTableSource) {
                SQLUnionQuery union = ((SQLUnionQueryTableSource)table).getUnion();
                for (SQLSelectQuery sqlSelectQuery : union.getChildren()) {
                    this.parsing(sqlSelectQuery, authData);
                }
            }
        }
    }
}

