/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.data.common.auth;

import cloud.agileframework.data.common.auth.AuthFilter;
import cloud.agileframework.data.common.auth.annotation.AuthData;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.data.util.ProxyUtils;

@Aspect
public class AuthDataAround {
    private final AuthFilter authFilter;

    public AuthDataAround(AuthFilter authFilter) {
        this.authFilter = authFilter;
    }

    @Around(value="@annotation(cloud.agileframework.data.common.auth.annotation.AuthData)")
    public Object roundAsp(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object proceed;
        Signature signature = proceedingJoinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        AuthData authData = method.getAnnotation(AuthData.class);
        if (authData == null) {
            Object bean = proceedingJoinPoint.getTarget();
            authData = ProxyUtils.getUserClass((Object)bean).getAnnotation(AuthData.class);
        }
        this.authFilter.setConfig(authData);
        try {
            Object[] args = proceedingJoinPoint.getArgs();
            proceed = proceedingJoinPoint.proceed(args);
        }
        finally {
            this.authFilter.clear();
        }
        return proceed;
    }
}

