/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.support.redis;

import cloud.agileframework.cache.support.AbstractAgileCache;
import cloud.agileframework.cache.support.redis.SecondCacheSerializerProvider;
import cloud.agileframework.cache.util.BeanUtil;
import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.support.NullValue;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class AgileRedis
extends AbstractAgileCache {
    private static final byte[] BINARY_NULL_VALUE = RedisSerializer.java().serialize(NullValue.INSTANCE);
    private static final Duration SLEEP_TIME = Duration.ZERO;
    private static final String TAG = UUID.randomUUID().toString();
    private final Logger logger = LoggerFactory.getLogger(AgileRedis.class);
    private final RedisConnectionFactory redisConnectionFactory;
    private final RedisCacheConfiguration cacheConfig;
    private final ConversionService conversionService;
    private final String name;
    private final SecondCacheSerializerProvider redisSerializer = (SecondCacheSerializerProvider)BeanUtil.getApplicationContext().getBean(SecondCacheSerializerProvider.class);

    AgileRedis(RedisCache cache, RedisConnectionFactory redisConnectionFactory) {
        super((Cache)cache);
        this.name = cache.getName();
        this.redisConnectionFactory = redisConnectionFactory;
        this.cacheConfig = cache.getCacheConfiguration();
        this.conversionService = this.cacheConfig.getConversionService();
    }

    private static String getCurrentProcessAndThreadInfo() {
        return TAG + Thread.currentThread().toString();
    }

    private static byte[] toBytes(String name) {
        return name.getBytes(StandardCharsets.UTF_8);
    }

    private static String createCacheLockKey(Object name) {
        return name.toString() + "~lock";
    }

    @Override
    public void put(Object key, Object value, Duration timeout) {
        this.logger.info("\u64cd\u4f5c:\u5b58\n\u533a\u57df\uff1a{}\nkey\u503c\uff1a{}\nvalue\u503c:{}\n", new Object[]{this.cache.getName(), key, value});
        this.execute(this.name, connection -> connection.set(this.createAndConvertCacheKey(key), this.serializeCacheValue(value), Expiration.from((Duration)timeout), RedisStringCommands.SetOption.UPSERT));
    }

    @Override
    public boolean containKey(Object key) {
        return this.execute(this.name, connection -> connection.exists(this.createAndConvertCacheKey(key)));
    }

    @Override
    public void addToMap(Object mapKey, Object key, Object value) {
        this.logger.info("\u64cd\u4f5c:\u5b58\n\u533a\u57df\uff1a{}\nMap\uff1a{}\nkey\u503c\uff1a{}\nvalue\u503c:{}\n", new Object[]{this.cache.getName(), mapKey, key, value});
        this.executeConsumer(this.name, connection -> connection.hSet(this.createAndConvertCacheKey(mapKey), this.serializeCacheValue(key), this.serializeCacheValue(value)));
    }

    @Override
    public Object getFromMap(Object mapKey, Object key) {
        List list = this.execute(this.name, connection -> connection.hMGet(this.createAndConvertCacheKey(mapKey), (byte[][])new byte[][]{this.serializeCacheValue(key)}));
        if (list == null || list.get(0) == null) {
            return null;
        }
        return this.deserializeCacheValue((byte[])list.get(0));
    }

    @Override
    public <T> T getFromMap(Object mapKey, Object key, Class<T> clazz) {
        Object value = this.getFromMap(mapKey, key);
        return (T)ObjectUtil.to((Object)value, (TypeReference)new TypeReference(clazz));
    }

    @Override
    public void removeFromMap(Object mapKey, Object key) {
        this.logger.info("\u64cd\u4f5c:\u5220\n\u533a\u57df\uff1a{}\nMap\uff1a{}\nkey\u503c\uff1a{}\n", new Object[]{this.cache.getName(), mapKey, key});
        this.executeConsumer(this.name, connection -> connection.hDel(this.createAndConvertCacheKey(mapKey), (byte[][])new byte[][]{this.serializeCacheValue(key)}));
    }

    @Override
    public void addToList(Object listKey, Object node) {
        this.logger.info("\u64cd\u4f5c:\u5b58\n\u533a\u57df\uff1a{}\nList\uff1a{}\nvalue\u503c:{}\n", new Object[]{this.cache.getName(), listKey, node});
        this.executeConsumer(this.name, connection -> connection.rPush(this.createAndConvertCacheKey(listKey), (byte[][])new byte[][]{this.serializeCacheValue(node)}));
    }

    @Override
    public Object getFromList(Object listKey, int index) {
        List list = this.execute(this.name, connection -> connection.lRange(this.createAndConvertCacheKey(listKey), (long)index, (long)(index + 1)));
        if (list == null) {
            return null;
        }
        return this.deserializeCacheValue((byte[])list.get(0));
    }

    @Override
    public <T> T getFromList(Object listKey, int index, Class<T> clazz) {
        Object value = this.getFromList(listKey, index);
        return (T)ObjectUtil.to((Object)value, (TypeReference)new TypeReference(clazz));
    }

    @Override
    public void removeFromList(Object listKey, int index) {
        this.logger.info("\u64cd\u4f5c:\u5220\n\u533a\u57df\uff1a{}\nList\uff1a{}\nvalue\u503c:{}\n", new Object[]{this.cache.getName(), listKey, index});
        this.executeConsumer(this.name, connection -> connection.lRem(this.createAndConvertCacheKey(listKey), 1L, this.serializeCacheValue(this.getFromList(listKey, index))));
    }

    @Override
    public void addToSet(Object setKey, Object node) {
        this.logger.info("\u64cd\u4f5c:\u5b58\n\u533a\u57df\uff1a{}\nSet\uff1a{}\nvalue\u503c:{}\n", new Object[]{this.cache.getName(), setKey, node});
        this.executeConsumer(this.name, connection -> connection.sAdd(this.createAndConvertCacheKey(setKey), (byte[][])new byte[][]{this.serializeCacheValue(node)}));
    }

    @Override
    public void removeFromSet(Object setKey, Object node) {
        this.logger.info("\u64cd\u4f5c:\u5220\n\u533a\u57df\uff1a{}\nSet\uff1a{}\nvalue\u503c:{}\n", new Object[]{this.cache.getName(), setKey, node});
        this.executeConsumer(this.name, connection -> connection.sRem(this.createAndConvertCacheKey(setKey), (byte[][])new byte[][]{this.serializeCacheValue(node)}));
    }

    @Override
    public boolean connectKey(Object setKey, Object node) {
        this.logger.info("\u64cd\u4f5c:\u5224\u65ad\n\u533a\u57df\uff1a{}\nSet\uff1a{}\nvalue\u503c:{}\u662f\u5426\u5b58\u5728\n", new Object[]{this.cache.getName(), setKey, node});
        return this.execute(this.name, connection -> connection.sIsMember(this.createAndConvertCacheKey(setKey), this.serializeCacheValue(node)));
    }

    public synchronized boolean lock(Object lock, Object value) {
        return this.execute(this.name, connection -> connection.setNX(this.createAndConvertCacheKey(AgileRedis.createCacheLockKey(lock)), this.serializeCacheValue(value)));
    }

    public synchronized boolean lock(Object lock, Object value, Duration timeout) {
        return this.execute(this.name, connection -> connection.set(this.createAndConvertCacheKey(AgileRedis.createCacheLockKey(lock)), this.serializeCacheValue(value), Expiration.from((Duration)timeout), RedisStringCommands.SetOption.SET_IF_ABSENT));
    }

    public synchronized boolean lockOnThreadLocal(Object lock) {
        String value = this.getLock(lock, String.class);
        if (value != null && value.equals(AgileRedis.getCurrentProcessAndThreadInfo())) {
            return true;
        }
        if (value == null) {
            return this.lock(lock, AgileRedis.getCurrentProcessAndThreadInfo());
        }
        return false;
    }

    public synchronized boolean lockOnThreadLocal(Object lock, Duration timeout) {
        String value = this.getLock(lock, String.class);
        if (value != null && value.equals(AgileRedis.getCurrentProcessAndThreadInfo())) {
            this.execute(this.name, connection -> connection.expire(this.createAndConvertCacheKey(AgileRedis.createCacheLockKey(lock)), timeout.getSeconds()));
            return true;
        }
        if (value == null) {
            return this.lock(lock, AgileRedis.getCurrentProcessAndThreadInfo(), timeout);
        }
        return false;
    }

    @Override
    public synchronized boolean lock(Object lock) {
        return this.lock(lock, new byte[0]);
    }

    @Override
    public synchronized void unlock(Object lock) {
        this.executeLockFree(connection -> connection.del((byte[][])new byte[][]{this.createAndConvertCacheKey(AgileRedis.createCacheLockKey(lock))}));
    }

    public synchronized boolean containLock(Object lock) {
        String value = this.getLock(lock, String.class);
        return !AgileRedis.getCurrentProcessAndThreadInfo().equals(value) && value != null;
    }

    @Override
    public List<String> keys(Object key) {
        Set set = this.execute(this.name, connection -> connection.keys(this.createAndConvertCacheKey(key)));
        return set.stream().map(n -> ((String)this.deserializeCacheKey((byte[])n)).replace(this.name + "::", "")).collect(Collectors.toList());
    }

    private byte[] createAndConvertCacheKey(Object key) {
        return this.serializeCacheKey(this.createCacheKey(key));
    }

    private byte[] serializeCacheKey(String cacheKey) {
        return ByteUtils.getBytes((ByteBuffer)this.cacheConfig.getKeySerializationPair().write((Object)cacheKey));
    }

    private String createCacheKey(Object key) {
        String convertedKey = this.convertKey(key);
        if (!this.cacheConfig.usePrefix()) {
            return convertedKey;
        }
        return this.prefixCacheKey(convertedKey);
    }

    private String prefixCacheKey(String key) {
        return this.cacheConfig.getKeyPrefixFor(this.name) + key;
    }

    private String convertKey(Object key) {
        TypeDescriptor source = TypeDescriptor.forObject((Object)key);
        if (this.conversionService.canConvert(source, TypeDescriptor.valueOf(String.class))) {
            return (String)this.conversionService.convert(key, String.class);
        }
        Method toString = ReflectionUtils.findMethod(key.getClass(), (String)"toString");
        if (toString != null && !Object.class.equals(toString.getDeclaringClass())) {
            return key.toString();
        }
        throw new IllegalStateException(String.format("Cannot convert %s to String. Register a Converter or override toString().", source));
    }

    private byte[] serializeCacheValue(Object value) {
        if (this.isAllowNullValues() && value instanceof NullValue) {
            return BINARY_NULL_VALUE;
        }
        return this.redisSerializer.serialize(value);
    }

    protected Object deserializeCacheValue(byte[] value) {
        if (this.isAllowNullValues() && ObjectUtils.nullSafeEquals((Object)value, (Object)BINARY_NULL_VALUE)) {
            return NullValue.INSTANCE;
        }
        return this.redisSerializer.deserialize(value);
    }

    protected Object deserializeCacheKey(byte[] value) {
        if (this.isAllowNullValues() && ObjectUtils.nullSafeEquals((Object)value, (Object)BINARY_NULL_VALUE)) {
            return NullValue.INSTANCE;
        }
        return this.cacheConfig.getKeySerializationPair().read(ByteBuffer.wrap(value));
    }

    private boolean isAllowNullValues() {
        return ((RedisCache)this.cache).isAllowNullValues();
    }

    private <T> T execute(String name, Function<RedisConnection, T> callback) {
        try (RedisConnection connection = this.redisConnectionFactory.getConnection();){
            this.checkAndPotentiallyWaitUntilUnlocked(name, connection);
            T t = callback.apply(connection);
            return t;
        }
    }

    private void executeConsumer(String name, Consumer<RedisConnection> callback) {
        try (RedisConnection connection = this.redisConnectionFactory.getConnection();){
            this.checkAndPotentiallyWaitUntilUnlocked(name, connection);
            callback.accept(connection);
        }
    }

    private void checkAndPotentiallyWaitUntilUnlocked(String name, RedisConnection connection) {
        if (!this.isLockingCacheWriter()) {
            return;
        }
        try {
            while (this.doCheckLock(name, connection)) {
                Thread.sleep(SLEEP_TIME.toMillis());
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new PessimisticLockingFailureException(String.format("Interrupted while waiting to unlock cache %s", name), (Throwable)ex);
        }
    }

    private boolean isLockingCacheWriter() {
        return !SLEEP_TIME.isZero() && !SLEEP_TIME.isNegative();
    }

    private boolean doCheckLock(Object name, RedisConnection connection) {
        return Boolean.TRUE.equals(connection.exists(this.createAndConvertCacheKey(AgileRedis.createCacheLockKey(name))));
    }

    public <T> T getLock(Object lock, Class<T> clazz) {
        byte[] v = this.execute(this.name, connection -> connection.get(this.createAndConvertCacheKey(AgileRedis.createCacheLockKey(lock))));
        return (T)ObjectUtil.to((Object)this.deserializeCacheValue(v), (TypeReference)new TypeReference(clazz));
    }

    private void executeLockFree(Consumer<RedisConnection> callback) {
        try (RedisConnection connection = this.redisConnectionFactory.getConnection();){
            callback.accept(connection);
        }
    }

    public void putIgnoreAggregate(Object key, Object value) {
        this.execute(this.name, connection -> connection.set(this.createAndConvertCacheKey(key), this.serializeCacheValue(value)));
    }

    public void putIgnoreAggregate(Object key, Object value, Duration timeout) {
        this.execute(this.name, connection -> connection.set(this.createAndConvertCacheKey(key), this.serializeCacheValue(value), Expiration.from((Duration)timeout), RedisStringCommands.SetOption.UPSERT));
    }

    @Override
    public void put(Object key, Object value) {
        this.logger.info("\u64cd\u4f5c:\u5b58\n\u533a\u57df\uff1a{}\nkey\u503c\uff1a{}\nvalue\u503c\uff1a{}\n", new Object[]{this.cache.getName(), key, value});
        if (Map.class.isAssignableFrom(value.getClass())) {
            this.evict(key);
            HashMap<byte[], byte[]> map = new HashMap<byte[], byte[]>(((Map)value).size());
            ((Map)value).forEach((eKey, eValue) -> map.put(this.serializeCacheValue(eKey), this.serializeCacheValue(eValue)));
            try {
                this.executeConsumer(this.name, connection -> connection.hMSet(this.createAndConvertCacheKey(key), map));
            }
            catch (RedisSystemException e) {
                map.forEach((eKey, eValue) -> this.addToMap(key, eKey, eValue));
            }
        } else if (List.class.isAssignableFrom(value.getClass())) {
            this.evict(key);
            int size = ((List)value).size();
            byte[][] arr = new byte[size][];
            List result = ((List)value).stream().map(this::serializeCacheValue).collect(Collectors.toList());
            byte[][] list = (byte[][])result.toArray((T[])arr);
            this.execute(this.name, connection -> connection.rPush(this.createAndConvertCacheKey(key), list));
        } else if (Set.class.isAssignableFrom(value.getClass())) {
            this.evict(key);
            int size = ((Set)value).size();
            byte[][] arr = new byte[size][];
            Set result = ((Set)value).stream().map(this::serializeCacheValue).collect(Collectors.toSet());
            byte[][] set = (byte[][])result.toArray((T[])arr);
            this.execute(this.name, connection -> connection.sAdd(this.createAndConvertCacheKey(key), set));
        } else {
            this.putIgnoreAggregate(key, value);
        }
    }

    @Override
    public <T> T get(Object key, Class<T> clazz) {
        return this.get(key, new TypeReference(clazz));
    }

    @Override
    public <T> T get(Object key, TypeReference<T> typeReference) {
        Object data;
        this.logger.info("\u64cd\u4f5c:\u53d6\n\u533a\u57df\uff1a{}\nkey\u503c\uff1a{}\n", (Object)this.cache.getName(), key);
        Class clazz = ClassUtil.getWrapper((Type)typeReference.getType());
        if (Map.class.isAssignableFrom(clazz)) {
            Map map = this.execute(this.name, connection -> connection.hGetAll(this.createAndConvertCacheKey(key)));
            HashMap res = new HashMap(map.size());
            map.forEach((k, v) -> res.put(this.deserializeCacheValue((byte[])k), this.deserializeCacheValue((byte[])v)));
            data = res;
        } else if (List.class.isAssignableFrom(clazz)) {
            List list = this.execute(this.name, connection -> connection.lRange(this.createAndConvertCacheKey(key), 0L, -1L));
            data = list.stream().map(this::deserializeCacheValue).collect(Collectors.toList());
        } else if (Set.class.isAssignableFrom(clazz)) {
            Set set = this.execute(this.name, connection -> connection.sMembers(this.createAndConvertCacheKey(key)));
            data = set.stream().map(this::deserializeCacheValue).collect(Collectors.toSet());
        } else {
            byte[] v2 = this.execute(this.name, connection -> connection.get(this.createAndConvertCacheKey(key)));
            data = this.deserializeCacheValue(v2);
        }
        return (T)ObjectUtil.to(data, (TypeReference)new TypeReference((Type)clazz));
    }

    @Override
    public Cache.ValueWrapper get(Object key) {
        byte[] v = this.execute(this.name, connection -> connection.get(this.createAndConvertCacheKey(key)));
        return new SimpleValueWrapper(this.deserializeCacheValue(v));
    }

    public Long getTimeout(Object key) {
        return this.execute(this.name, connection -> connection.ttl(this.createAndConvertCacheKey(key)));
    }

    public RedisConnection getNativeCache() {
        return this.redisConnectionFactory.getConnection();
    }

    public DataType typeKey(Object key) {
        return this.execute(this.name, connection -> connection.type(this.createAndConvertCacheKey(key)));
    }
}

