/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.support.ehcache;

import cloud.agileframework.cache.support.AgileCache;
import cloud.agileframework.cache.support.AgileCacheManager;
import cloud.agileframework.cache.support.ehcache.AgileEhCache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.springframework.cache.Cache;
import org.springframework.cache.ehcache.EhCacheCache;
import org.springframework.cache.ehcache.EhCacheCacheManager;

public class AgileEhCacheCacheManager
extends AgileCacheManager {
    private static EhCacheCacheManager cacheManager;

    public AgileEhCacheCacheManager(EhCacheCacheManager cacheManager) {
        AgileEhCacheCacheManager.setCacheManager(cacheManager);
    }

    public static EhCacheCacheManager getCacheManager() {
        return cacheManager;
    }

    public static void setCacheManager(EhCacheCacheManager cacheManager) {
        AgileEhCacheCacheManager.cacheManager = cacheManager;
    }

    @Override
    public AgileCache cover(Cache cache) {
        return new AgileEhCache((EhCacheCache)cache);
    }

    @Override
    public AgileCache getMissingCache(String cacheName) {
        CacheManager ehcacheCacheManager = cacheManager.getCacheManager();
        assert (ehcacheCacheManager != null);
        Ehcache target = ehcacheCacheManager.getEhcache(cacheName);
        if (target == null) {
            target = ehcacheCacheManager.addCacheIfAbsent(cacheName);
        }
        return this.cover((Cache)new EhCacheCache(target));
    }
}

