/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.support;

import cloud.agileframework.cache.support.AgileCache;
import java.util.concurrent.Callable;
import org.springframework.cache.Cache;
import org.springframework.data.redis.serializer.SerializationException;

public abstract class AbstractAgileCache
implements AgileCache {
    protected Cache cache;

    public AbstractAgileCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public String getName() {
        return this.cache.getName();
    }

    @Override
    public Object getNativeCache() {
        return this.cache.getNativeCache();
    }

    @Override
    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        return this.cache.putIfAbsent(key, value);
    }

    @Override
    public void put(Object key, Object value) {
        this.cache.put(key, value);
    }

    @Override
    public <T> T get(Object key, Class<T> clazz) {
        try {
            return (T)this.cache.get(key, clazz);
        }
        catch (SerializationException e) {
            this.cache.evict(key);
            return null;
        }
    }

    @Override
    public void evict(Object key) {
        this.cache.evict(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    public Cache.ValueWrapper get(Object key) {
        try {
            return this.cache.get(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        return (T)this.cache.get(key, valueLoader);
    }
}

