/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.properties;

import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.config.CacheConfiguration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.ehcache")
public class EhCacheProperties
implements InitializingBean {
    private String defaultConfigName = "common-cache";
    private String path = "/ehcache";
    private Map<String, CacheConfiguration> regions = new HashMap<String, CacheConfiguration>();

    public String getDefaultConfigName() {
        return this.defaultConfigName;
    }

    public void setDefaultConfigName(String defaultConfigName) {
        this.defaultConfigName = defaultConfigName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Map<String, CacheConfiguration> getRegions() {
        return this.regions;
    }

    public void setRegions(Map<String, CacheConfiguration> regions) {
        this.regions = regions;
    }

    public void afterPropertiesSet() throws Exception {
        this.regions.computeIfAbsent(this.defaultConfigName, a -> {
            CacheConfiguration defaultCacheConfiguration = new CacheConfiguration();
            defaultCacheConfiguration.setDiskExpiryThreadIntervalSeconds(120L);
            defaultCacheConfiguration.setDiskSpoolBufferSizeMB(30);
            defaultCacheConfiguration.setEternal(false);
            defaultCacheConfiguration.setMaxEntriesLocalDisk(10000000L);
            defaultCacheConfiguration.setMaxEntriesLocalHeap(10000L);
            defaultCacheConfiguration.setMemoryStoreEvictionPolicy("LRU");
            defaultCacheConfiguration.setTimeToIdleSeconds(0L);
            defaultCacheConfiguration.setTimeToLiveSeconds(0L);
            return defaultCacheConfiguration;
        });
    }
}

