/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.service;

import cloud.agileframework.abstractbusiness.controller.BaseBusinessService;
import cloud.agileframework.abstractbusiness.pojo.EntityExistsException;
import cloud.agileframework.abstractbusiness.pojo.entity.IBaseEntity;
import cloud.agileframework.abstractbusiness.pojo.vo.BaseInParamVo;
import cloud.agileframework.abstractbusiness.service.ISecurityService;
import cloud.agileframework.common.DataException;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.collection.TreeBase;
import cloud.agileframework.common.util.collection.TreeUtil;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.data.common.dao.BaseDao;
import cloud.agileframework.dictionary.util.ConvertDicAnnotation;
import cloud.agileframework.dictionary.util.TranslateException;
import cloud.agileframework.mvc.exception.AgileArgumentException;
import cloud.agileframework.validate.ValidateMsg;
import cloud.agileframework.validate.ValidateUtil;
import com.google.common.collect.Maps;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class GenericService {
    public static GenericService INSTANCE;
    private final BaseDao dao;
    private final ISecurityService security;

    public GenericService(BaseDao dao, ISecurityService security) {
        this.dao = dao;
        this.security = security;
    }

    public static <A, B> List<B> toList(List<A> data, Class<B> type) {
        TypeReference toClass = new TypeReference<List<B>>(){};
        ParameterizedType parameterizedType = (ParameterizedType)toClass.getType();
        parameterizedType = TypeUtils.parameterizeWithOwner((Type)parameterizedType.getOwnerType(), (Class)((Class)parameterizedType.getRawType()), (Type[])new Type[]{type});
        toClass.replace((Type)parameterizedType);
        List result = (List)ObjectUtil.to(data, (TypeReference)toClass);
        ConvertDicAnnotation.cover((Collection)result);
        return result;
    }

    public static <A, B> B to(A data, Class<B> type) {
        if (data == null) {
            return null;
        }
        TypeReference typeReference = new TypeReference(type);
        Object o = ObjectUtil.to(data, (TypeReference)typeReference);
        if (o == null) {
            throw new DataException("\u6570\u636e\u7c7b\u578b\u8f6c\u6362\u5931\u8d25" + data.getClass() + "\u65e0\u6cd5\u4e0e" + type + "\u7c7b\u578b\u4e4b\u95f4\u5b8c\u6210\u4e92\u8f6c");
        }
        ConvertDicAnnotation.cover((Object)o);
        return (B)o;
    }

    public BaseDao dao() {
        return this.dao;
    }

    public ISecurityService security() {
        return this.security;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public <E extends IBaseEntity> List<E> saveDataWithNewTransaction(List<E> data) throws DataException {
        return this.saveData((E)((Object)data));
    }

    @Transactional(rollbackFor={Exception.class})
    public <E extends IBaseEntity> List<E> saveData(List<E> data) {
        ArrayList result = Lists.newArrayList();
        for (IBaseEntity node : data) {
            Object v = this.dao().getId((Object)node);
            if (StringUtils.isBlank((CharSequence)String.valueOf(v))) {
                this.dao().setId((Object)node, null);
            }
            if (node.getCreateUser() == null) {
                node.setCreateUser(this.security().currentUser());
            }
            result.add(this.dao().saveAndReturn((Object)node));
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public <E extends IBaseEntity> E saveData(E data) {
        Object v = this.dao().getId(data);
        if (StringUtils.isBlank((CharSequence)String.valueOf(v))) {
            this.dao().setId(data, null);
        }
        if (data.getCreateUser() == null) {
            data.setCreateUser(this.security().currentUser());
        }
        return (E)((IBaseEntity)this.dao().saveOrUpdate(data));
    }

    @Transactional(rollbackFor={Exception.class})
    public <E extends IBaseEntity> boolean deleteById(Object id, Class<E> javaType) {
        return this.dao().deleteById(javaType, id);
    }

    @Transactional(rollbackFor={Exception.class})
    public <E extends IBaseEntity> void deleteByIds(List<String> id, Class<E> javaType) {
        this.dao().deleteInBatch(javaType, id);
    }

    @Transactional(rollbackFor={Exception.class})
    public <E extends IBaseEntity> E updateData(E data) {
        if (data != null && data.getUpdateUser() == null) {
            data.setUpdateUser(this.security().currentUser());
        }
        return (E)((IBaseEntity)this.dao().updateOfNotNull(data));
    }

    public <I extends BaseInParamVo, E extends IBaseEntity> List<E> list(Class<E> entityClass, I inParam) {
        IBaseEntity data = (IBaseEntity)ObjectUtil.to(inParam, (TypeReference)new TypeReference(entityClass));
        if (data == null) {
            return this.dao().findAllByClass(entityClass, inParam.sort());
        }
        return this.dao().findAll((Object)data, inParam.sort());
    }

    public <I extends BaseInParamVo, V> List<V> list(Class<V> outVoClass, I inParam, String sql) {
        if (inParam == null) {
            return this.dao().findBySQL(sql, outVoClass, new Object[]{Maps.newHashMap()});
        }
        return this.dao().findBySQL(sql, outVoClass, new Object[]{inParam});
    }

    public <I extends BaseInParamVo, J, T> List<T> list(Class<J> queryBy, Class<T> outBy, I inParam) {
        Object data = ObjectUtil.to(inParam, (TypeReference)new TypeReference(queryBy));
        List list = data == null ? this.dao().findAllByClass(queryBy, inParam.sort()) : this.dao().findAll(data, inParam.sort());
        return GenericService.toList(list, outBy);
    }

    public <I extends BaseInParamVo, J, T> List<T> list(Class<J> queryBy, Class<T> outBy, I inParam, String sql) {
        List list = inParam == null ? this.dao().findBySQL(sql, queryBy, new Object[]{Maps.newHashMap()}) : this.dao().findBySQL(sql, queryBy, new Object[]{inParam});
        return GenericService.toList(list, outBy);
    }

    public <E extends IBaseEntity> E queryById(Class<E> data, Object id) {
        return (E)((IBaseEntity)this.dao().findOne(data, id));
    }

    public <V, E extends IBaseEntity> V queryOne(Class<V> outVoClass, Class<E> doClass, String id, String sql, String idPlaceholder) {
        HashMap params = Maps.newHashMap();
        params.put(idPlaceholder, id);
        IBaseEntity data = (IBaseEntity)this.dao().findOne(sql, doClass, new Object[]{params});
        return (V)ObjectUtil.to((Object)data, (TypeReference)new TypeReference(outVoClass));
    }

    public <T> T queryOne(Class<T> outClass, String id, String sql, String idPlaceholder) {
        HashMap params = Maps.newHashMap();
        params.put(idPlaceholder, id);
        return (T)this.dao().findOne(sql, outClass, new Object[]{params});
    }

    public <I extends BaseInParamVo, V> Page<V> page(Class<V> outVoClass, I inParam, String sql) {
        PageRequest pageRequest = PageRequest.of((int)(inParam.getPageNum() - 1), (int)inParam.getPageSize());
        return this.dao().pageBySQL(inParam.parseOrder(sql), pageRequest, outVoClass, new Object[]{inParam});
    }

    public <I extends BaseInParamVo, J, T> Page<T> page(Class<J> queryBy, Class<T> outBy, I inParam, String sql) {
        PageRequest pageRequest = PageRequest.of((int)(inParam.getPageNum() - 1), (int)inParam.getPageSize());
        Page page = this.dao().pageBySQL(inParam.parseOrder(sql), pageRequest, queryBy, new Object[]{inParam});
        return new PageImpl(GenericService.toList(page.getContent(), outBy), page.getPageable(), page.getTotalElements());
    }

    public <I extends BaseInParamVo, E extends IBaseEntity> Page<E> page(Class<E> entityClass, I inParam) {
        IBaseEntity data = (IBaseEntity)ObjectUtil.to(inParam, (TypeReference)new TypeReference(entityClass));
        PageRequest pageRequest = PageRequest.of((int)(inParam.getPageNum() - 1), (int)inParam.getPageSize(), (Sort)inParam.sort());
        if (data == null) {
            return this.dao().pageByClass(entityClass, pageRequest);
        }
        return this.dao().page((Object)data, pageRequest);
    }

    public <I extends BaseInParamVo, J, T> Page<T> page(Class<J> queryBy, Class<T> outBy, I inParam) {
        Object data = ObjectUtil.to(inParam, (TypeReference)new TypeReference(queryBy));
        PageRequest pageRequest = PageRequest.of((int)(inParam.getPageNum() - 1), (int)inParam.getPageSize(), (Sort)inParam.sort());
        Page page = data == null ? this.dao().pageByClass(queryBy, pageRequest) : this.dao().page(data, pageRequest);
        return new PageImpl(GenericService.toList(page.getContent(), outBy), page.getPageable(), page.getTotalElements());
    }

    @Transactional(rollbackFor={Exception.class})
    public <E extends IBaseEntity> void clean(Class<E> data) {
        this.dao().deleteAllInBatch(data);
    }

    public Set<TreeBase> tree(List<TreeBase> all, String rootParentId) {
        return TreeUtil.createTree(all, (String)rootParentId);
    }

    public void validate(Object pojo, Class<?> ... groups) throws AgileArgumentException {
        List list = ValidateUtil.validate((Object)pojo, (Class[])groups);
        if (!list.isEmpty()) {
            throw new AgileArgumentException(list);
        }
    }

    public void validateEntity(Object pojo, Class<?> ... groups) throws AgileArgumentException {
        List<ValidateMsg> list = BaseBusinessService.toValidateMessages(pojo, groups);
        if (!list.isEmpty()) {
            throw new AgileArgumentException(list);
        }
    }

    public <E extends IBaseEntity> void validateEntityExists(E pojo) throws EntityExistsException, TranslateException {
        Object id = null;
        if (pojo != null) {
            id = this.dao().getId(pojo);
        }
        if (id == null) {
            return;
        }
        List old = this.dao().findAllByArrayId(pojo.getClass(), new Object[]{id});
        if (old == null || old.isEmpty()) {
            throw new EntityExistsException(id + "");
        }
    }
}

