/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.controller;

import cloud.agileframework.abstractbusiness.controller.IBaseController;
import cloud.agileframework.abstractbusiness.pojo.entity.IBaseEntity;
import cloud.agileframework.abstractbusiness.pojo.vo.BaseInParamVo;
import cloud.agileframework.abstractbusiness.pojo.vo.IBaseOutParamVo;
import cloud.agileframework.mvc.annotation.AgileInParam;
import cloud.agileframework.mvc.base.RETURN;
import cloud.agileframework.validate.annotation.Validate;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;

public interface IBaseDeleteController<E extends IBaseEntity, I extends BaseInParamVo, O extends IBaseOutParamVo>
extends IBaseController<E, O> {
    public static final String ID = "id";

    @Validate(value="id", nullable=false)
    @DeleteMapping(value={"${agile.base-service.deleteById:/{id}}"})
    default public RETURN delete(@PathVariable(value="id") String id) {
        this.genericService().deleteById(id, this.getEntityClass());
        return RETURN.SUCCESS;
    }

    @Validate(nullable=false)
    @DeleteMapping(value={"${agile.base-service.deleteByIds:}"})
    default public RETURN delete(@AgileInParam(value="id") List<String> ids) throws Exception {
        this.genericService().deleteByIds(ids, this.getEntityClass());
        return RETURN.SUCCESS;
    }

    @DeleteMapping(value={"${agile.base-service.clean:/all}"})
    default public RETURN clean() {
        this.genericService().clean(this.getEntityClass());
        return RETURN.SUCCESS;
    }
}

