/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.controller;

import cloud.agileframework.abstractbusiness.controller.IBaseController;
import cloud.agileframework.abstractbusiness.pojo.entity.IBaseEntity;
import cloud.agileframework.abstractbusiness.pojo.vo.BaseInParamVo;
import cloud.agileframework.abstractbusiness.pojo.vo.IBaseOutParamVo;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.mvc.annotation.AgileInParam;
import cloud.agileframework.mvc.base.RETURN;
import cloud.agileframework.mvc.param.AgileReturn;
import cloud.agileframework.security.filter.login.CustomerUserDetails;
import cloud.agileframework.spring.util.SecurityUtil;
import cloud.agileframework.validate.group.Insert;
import java.util.Date;
import javax.validation.groups.Default;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.bind.annotation.PostMapping;

public interface IBaseSaveController<E extends IBaseEntity, I extends BaseInParamVo, O extends IBaseOutParamVo>
extends IBaseController<E, O> {
    @PostMapping(value={"${agile.base-service.save:}"})
    default public RETURN save(@AgileInParam I inParam) throws Exception {
        this.genericService().validate(inParam, Default.class, Insert.class);
        IBaseEntity data = (IBaseEntity)ObjectUtil.to(inParam, (TypeReference)new TypeReference(this.getEntityClass()));
        this.genericService().validateEntity(data, Default.class, Insert.class);
        try {
            data.setCreateTime(new Date());
            UserDetails currentUser = SecurityUtil.currentUser();
            if (currentUser instanceof CustomerUserDetails) {
                data.setCreateUser(((CustomerUserDetails)currentUser).id());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        AgileReturn.add((String)"result", this.toSingleOutVo(this.genericService().saveData(data)));
        return RETURN.SUCCESS;
    }
}

