/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.controller;

import cloud.agileframework.abstractbusiness.service.GenericService;
import cloud.agileframework.common.annotation.Remark;
import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.jpa.dao.Dao;
import cloud.agileframework.mvc.annotation.AgileService;
import cloud.agileframework.mvc.annotation.Mapping;
import cloud.agileframework.spring.util.BeanUtil;
import cloud.agileframework.validate.ValidateMsg;
import cloud.agileframework.validate.ValidateUtil;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.springframework.beans.factory.annotation.Autowired;

@AgileService
@Mapping(value={"${agile.base-service.rootPath:${agile.module-name:api}/{model}/default}"})
public class BaseBusinessService {
    public static final String MODEL = "model";
    @Autowired
    private GenericService genericService;

    public static List<ValidateMsg> toValidateMessages(Object data, Class<?> ... groups) {
        if (data instanceof Class) {
            return Lists.newArrayList();
        }
        List result = ValidateUtil.validate((Object)data, (Class[])groups);
        if (!result.isEmpty()) {
            return result;
        }
        Set columns = ClassUtil.getAllEntityAnnotation(data.getClass(), Column.class);
        Set any = columns.stream().filter(c -> ((Column)c.getAnnotation()).unique()).map(ClassUtil.Target::getMember).collect(Collectors.toSet());
        Dao dao = (Dao)BeanUtil.getBean(Dao.class);
        if (!any.isEmpty()) {
            return any.stream().map(member -> {
                String name = member.getName();
                if (member instanceof Method && name.startsWith("get")) {
                    name = StringUtil.toLowerName((String)name.substring(3));
                }
                return name;
            }).map(fieldName -> {
                Object demo = ClassUtil.newInstance(data.getClass());
                if (demo == null) {
                    return null;
                }
                Object fieldValue = BaseBusinessService.setFieldValue(data, fieldName, demo);
                List demoList = dao.findAll(demo).stream().filter(n -> !Objects.equals(dao.getId(n), dao.getId(data))).collect(Collectors.toList());
                if (!demoList.isEmpty()) {
                    return new ValidateMsg(fieldValue + "\u4e0d\u5141\u8bb8\u91cd\u590d", fieldName, fieldValue);
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map<String, Member> map = columns.stream().collect(Collectors.toMap(c -> ((Column)c.getAnnotation()).name(), ClassUtil.Target::getMember));
        Table table = data.getClass().getAnnotation(Table.class);
        if (table.uniqueConstraints().length > 0) {
            for (UniqueConstraint uniqueConstraint : table.uniqueConstraints()) {
                Object testData = ClassUtil.newInstance(data.getClass());
                if (testData == null) continue;
                ArrayList remarks = Lists.newArrayList();
                Arrays.stream(uniqueConstraint.columnNames()).map(map::get).filter(Objects::nonNull).map(member -> {
                    String name = member.getName();
                    if (member instanceof Method && name.startsWith("get")) {
                        name = StringUtil.toLowerName((String)name.substring(3));
                    }
                    return name;
                }).forEach(fieldName -> {
                    Remark remark = (Remark)ClassUtil.getFieldAnnotation(data.getClass(), (String)fieldName, Remark.class);
                    String fieldRemark = remark == null ? fieldName : remark.value();
                    remarks.add(fieldRemark);
                    BaseBusinessService.setFieldValue(data, fieldName, testData);
                });
                List demoList = dao.findAll(testData).stream().filter(n -> !Objects.equals(dao.getId(n), dao.getId(data))).collect(Collectors.toList());
                if (demoList.isEmpty()) continue;
                return Lists.newArrayList((Object[])new ValidateMsg[]{new ValidateMsg(String.join((CharSequence)",", remarks) + "\u7ec4\u5408\u4e0d\u80fd\u91cd\u590d", "", (Object)"")});
            }
        }
        return Lists.newArrayList();
    }

    private static Object setFieldValue(Object data, String fieldName, Object testData) {
        Field field = ClassUtil.getField(data.getClass(), (String)fieldName);
        Object fieldValue = ObjectUtil.getFieldValue((Object)data, (Field)field);
        ObjectUtil.setValue((Object)testData, (Field)field, (Object)fieldValue);
        return fieldValue;
    }
}

