/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.service;

import cloud.agileframework.abstractbusiness.pojo.template.curd.ButtonType;
import cloud.agileframework.abstractbusiness.pojo.template.curd.Column;
import cloud.agileframework.abstractbusiness.pojo.template.curd.Table;
import cloud.agileframework.abstractbusiness.pojo.template.view.form.FormValidate;
import cloud.agileframework.abstractbusiness.pojo.template.view.form.data.DicFormElementData;
import cloud.agileframework.abstractbusiness.pojo.template.view.form.data.FormElementData;
import cloud.agileframework.abstractbusiness.pojo.template.view.form.data.FormElementDataFactory;
import cloud.agileframework.abstractbusiness.pojo.vo.BaseInParamVo;
import cloud.agileframework.abstractbusiness.service.IBaseFileService;
import cloud.agileframework.abstractbusiness.service.TemplateService;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.collection.TreeBase;
import cloud.agileframework.common.util.collection.TreeUtil;
import cloud.agileframework.common.util.file.poi.CellInfo;
import cloud.agileframework.common.util.file.poi.ExcelFile;
import cloud.agileframework.common.util.file.poi.POIUtil;
import cloud.agileframework.common.util.file.poi.SheetData;
import cloud.agileframework.common.util.http.NotFoundRequestMethodException;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.dictionary.annotation.DirectionType;
import cloud.agileframework.dictionary.util.ConvertConf;
import cloud.agileframework.dictionary.util.ConvertDicMap;
import cloud.agileframework.jpa.dao.Dao;
import cloud.agileframework.mvc.annotation.AgileService;
import cloud.agileframework.mvc.annotation.Mapping;
import cloud.agileframework.mvc.base.RETURN;
import cloud.agileframework.mvc.exception.AgileArgumentException;
import cloud.agileframework.mvc.param.AgileParam;
import cloud.agileframework.mvc.param.AgileReturn;
import cloud.agileframework.spring.util.BeanUtil;
import cloud.agileframework.spring.util.POIUtilOfMultipartFile;
import cloud.agileframework.spring.util.RequestWrapper;
import cloud.agileframework.validate.ValidateConfig;
import cloud.agileframework.validate.ValidateMsg;
import cloud.agileframework.validate.ValidateUtil;
import cloud.agileframework.validate.group.Insert;
import cloud.agileframework.validate.group.Update;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.WebUtils;

@AgileService
public class TemplateEngin {
    @Autowired(required=false)
    private TemplateService templateService;
    @Value(value="${agile.base-service.page:/page}")
    private String page;
    @Value(value="${agile.base-service.deleteByIds:}")
    private String deleteByIds;
    @Value(value="${agile.base-service.save:}")
    private String save;
    @Value(value="${agile.base-service.update:}")
    private String update;
    @Value(value="${agile.base-service.query:/list}")
    private String query;
    @Value(value="${agile.base-service.queryById:/{id}}")
    private String queryById;
    @Value(value="${agile.base-service.deleteById:/{id}}")
    private String deleteById;
    @Value(value="${agile.base-service.tree:/tree}")
    private String tree;
    @Value(value="${agile.base-service.template:/template}")
    private String template;
    @Value(value="${agile.base-service.upload:/upload}")
    private String upload;
    @Value(value="${agile.base-service.download:/download}")
    private String download;
    @Autowired
    private Dao dao;
    private static final Map<String, List<CellInfo>> excelCache = Maps.newHashMap();
    private static final Map<String, List<ValidateConfig>> validateConfigCache = Maps.newHashMap();
    private static final Map<String, List<ConvertConf>> dicConfigCache = Maps.newHashMap();
    private final PathMatcher pathMatcher = new AntPathMatcher();

    @Mapping(value={"/api/v${version:1}/*", "/api/v${version:1}/**"})
    public Object router(HttpServletRequest request) throws NotFoundRequestMethodException, IOException, AgileArgumentException {
        String path = request.getRequestURI();
        Table table = this.templateService.getTableByUrl(path);
        ButtonType type = this.byUrl(request);
        return this.parse(table, type);
    }

    public Object parse(String id, ButtonType type) throws IOException, AgileArgumentException {
        return this.parse(this.templateService.getTable(id), type);
    }

    public Object parse(Table table, ButtonType type) throws AgileArgumentException, IOException {
        Map inParam = AgileParam.getInParam();
        switch (type) {
            case ADD: {
                this.validateAndThrow(table, Insert.class);
                inParam.putAll(this.templateService.generatorId(table.getId()));
                this.dao.updateBySQL(table.getMeta().getInsert(), new Object[]{inParam});
                break;
            }
            case DELETE: {
                this.dao.updateBySQL(table.getMeta().getDelete(), new Object[]{inParam});
                break;
            }
            case ROW_DELETE: {
                this.dao.updateBySQL(table.getMeta().getDelete(), new Object[]{inParam});
                break;
            }
            case ROW_UPDATE: {
                this.validateAndThrow(table, Update.class);
                this.dao.updateBySQL(table.getMeta().getUpdate(), new Object[]{inParam});
                break;
            }
            case PAGE: {
                BaseInParamVo baseInParamVo = (BaseInParamVo)AgileParam.getInParam(BaseInParamVo.class);
                String sql = baseInParamVo.parseOrder(table.getMeta().getPage());
                Page result = this.dao.pageBySQL(sql, baseInParamVo.getPageNum().intValue(), baseInParamVo.getPageSize().intValue(), new Object[]{inParam});
                AgileReturn.add((String)"result", (Object)result);
                break;
            }
            case ROW_DETAIL: {
                Map result = this.dao.findOne(table.getMeta().getDetail(), new Object[]{inParam});
                AgileReturn.add((String)"result", (Object)result);
                break;
            }
            case TREE: {
                List list = this.dao.findBySQL(table.getMeta().getTree(), TreeBase.class, new Object[]{inParam});
                SortedSet result = TreeUtil.createTree((Collection)list, null);
                AgileReturn.add((String)"result", (Object)result);
                break;
            }
            case TEMPLATE: {
                return TemplateEngin.template(table, table.getName() + "\u5bfc\u5165\u6a21\u677f");
            }
            case DOWNLOAD: {
                BaseInParamVo baseInParamVo2 = (BaseInParamVo)AgileParam.getInParam(BaseInParamVo.class);
                String sql2 = baseInParamVo2.parseOrder(table.getMeta().getPage());
                List list2 = this.dao.findBySQL(sql2, new Object[]{inParam});
                return IBaseFileService.createExcel(list2, TemplateEngin.cellInfos(table), table.getName() + "\u5bfc\u51fa\u6570\u636e", POIUtil.VERSION.V2007);
            }
            case UPLOAD: {
                MultipartFile file = AgileParam.getInParamOfFile((String)"file");
                ArrayList data = Lists.newArrayList();
                Workbook workbook = POIUtilOfMultipartFile.readFile((MultipartFile)file);
                List cellInfos3 = table.getColumn().values().stream().map(Column::to).collect(Collectors.toList());
                for (Sheet sheet : workbook) {
                    POIUtil.readColumnInfo(cellInfos3, (Sheet)sheet);
                    int rowTotal = sheet.getLastRowNum() - 1;
                    Integer max = (Integer)BeanUtil.getApplicationContext().getEnvironment().getProperty("agile.base-service.importMaxNum", Integer.class, (Object)500);
                    if (rowTotal > max) {
                        throw new AgileArgumentException("\u6700\u5927\u53ea\u5141\u8bb8\u5bfc\u5165" + max + "\u6761\u6570\u636e");
                    }
                    int maxRowNum = sheet.getLastRowNum();
                    int rowNum = 1;
                    while (rowNum <= maxRowNum) {
                        Row row = sheet.getRow(rowNum++);
                        Map rowData = (Map)POIUtil.readRow((TypeReference)new TypeReference<Map<String, Object>>(){}, cellInfos3, (Row)row, (Workbook)workbook);
                        ConvertDicMap.coverMapDictionary((Map)rowData, TemplateEngin.dicConfigs(table));
                        data.add(rowData);
                    }
                }
                ArrayList success = Lists.newArrayList();
                ArrayList error = Lists.newArrayList();
                List allData = data.stream().map(IBaseFileService.ProxyData::new).collect(Collectors.toList());
                for (IBaseFileService.ProxyData in : allData) {
                    List validateMsg = ValidateUtil.handleValidateData((Object)data, TemplateEngin.validateConfigs(table));
                    in.setMsg(validateMsg);
                    if (validateMsg.isEmpty()) {
                        success.add(in);
                        continue;
                    }
                    error.add(in);
                }
                if (error.isEmpty()) {
                    this.dao.save((Iterable)success.stream().map(IBaseFileService.ProxyData::getIn).collect(Collectors.toList()));
                    break;
                }
                return TemplateEngin.exportError(table, TemplateEngin.cellInfos(table), error);
            }
        }
        return RETURN.SUCCESS;
    }

    private static List<CellInfo> cellInfos(Table table) {
        String id = table.getId();
        return excelCache.computeIfAbsent(id, key -> {
            List value = table.getColumn().values().stream().map(Column::to).collect(Collectors.toList());
            excelCache.put(id, value);
            return value;
        });
    }

    private static List<ValidateConfig> validateConfigs(Table table) {
        String id = table.getId();
        return validateConfigCache.computeIfAbsent(id, key -> {
            List value = table.getColumn().values().stream().filter(Objects::nonNull).map(a -> {
                FormValidate validate = a.getValidate();
                if (validate == null) {
                    return null;
                }
                ValidateConfig c = validate.to();
                c.setValue(a.getCode());
                return c;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            validateConfigCache.put(id, value);
            return value;
        });
    }

    private static List<ConvertConf> dicConfigs(Table table) {
        String id = table.getId();
        return dicConfigCache.computeIfAbsent(id, key -> {
            List value = table.getColumn().values().stream().map(a -> {
                FormElementData data = a.getForm().getData();
                if (data instanceof DicFormElementData) {
                    return ConvertConf.builder().ref(a.getCode()).toRef(a.getCode() + "_convert_name").directionType(DirectionType.ID_TO_NAME).dataSource(((DicFormElementData)data).getDataSource()).build();
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            dicConfigCache.put(id, value);
            return value;
        });
    }

    private static ExcelFile template(Table table, String filename) throws IOException {
        List cellInfos = table.getColumn().values().stream().map(Column::to).collect(Collectors.toList());
        Workbook workbook = POIUtil.creatExcel((POIUtil.VERSION)POIUtil.VERSION.V2007, (SheetData[])new SheetData[]{SheetData.builder().setCells(cellInfos).setData((List)Lists.newArrayList()).build()});
        return new ExcelFile(filename, workbook);
    }

    private static ExcelFile exportError(Table table, List<CellInfo> cellInfos, List<IBaseFileService.ProxyData<Map<String, Object>>> data) throws IOException {
        ExcelFile excelFile = TemplateEngin.template(table, table.getName() + "\u5bfc\u5165\u9519\u8bef\u6570\u636e");
        Workbook workbook = excelFile.getWorkbook();
        for (Sheet sheet : workbook) {
            POIUtil.readColumnInfo(cellInfos, (Sheet)sheet);
            for (int rowNum = 0; rowNum < data.size(); ++rowNum) {
                IBaseFileService.ProxyData<Map<String, Object>> proxyDataRow = data.get(rowNum);
                Map<String, ValidateMsg> map = proxyDataRow.getMsg().stream().collect(Collectors.toMap(ValidateMsg::getItem, row -> row));
                Row row2 = sheet.createRow(rowNum + 1);
                for (CellInfo cellInfo : cellInfos) {
                    if (cellInfo.getSort() < 0) continue;
                    String columnKey = cellInfo.getKey();
                    ValidateMsg error = map.get(columnKey);
                    Cell cell = row2.createCell(cellInfo.getSort());
                    if (error == null) {
                        Object value = ObjectUtil.getFieldValue(proxyDataRow.getIn(), (String)columnKey);
                        String text = value == null ? "" : value.toString();
                        POIUtil.addCellValue((Workbook)workbook, (Cell)cell, (String)text, (Font)workbook.createFont());
                        continue;
                    }
                    Font font = workbook.createFont();
                    font.setColor(IndexedColors.RED.getIndex());
                    Object itemValue = error.getItemValue();
                    CellStyle style = workbook.createCellStyle();
                    style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    style.setFillForegroundColor(IndexedColors.WHITE.getIndex());
                    style.setBorderBottom(BorderStyle.THICK);
                    style.setBottomBorderColor(IndexedColors.RED1.getIndex());
                    style.setBorderLeft(BorderStyle.THICK);
                    style.setLeftBorderColor(IndexedColors.RED1.getIndex());
                    style.setBorderRight(BorderStyle.THICK);
                    style.setRightBorderColor(IndexedColors.RED1.getIndex());
                    style.setBorderTop(BorderStyle.THICK);
                    style.setTopBorderColor(IndexedColors.RED1.getIndex());
                    cell.setCellStyle(style);
                    POIUtil.addCellValue((Workbook)workbook, (Cell)cell, (String)(itemValue == null ? "" : itemValue.toString()), (Font)font);
                    POIUtil.addComment((Workbook)workbook, (Cell)cell, (String)error.getMessage());
                }
            }
        }
        return excelFile;
    }

    @Mapping(value={"/api/v${version:1}/formElementData"})
    public Object formElementData() throws Exception {
        FormElementData formElementData = FormElementDataFactory.create((JSONObject)AgileParam.getInParam(JSONObject.class));
        if (formElementData == null) {
            return null;
        }
        return formElementData.data();
    }

    private void validateAndThrow(Table table, Class<?> group) throws AgileArgumentException {
        List<ValidateMsg> result = this.validate(TemplateEngin.validateConfigs(table), AgileParam.getInParam(), group);
        if (result.isEmpty()) {
            return;
        }
        throw new AgileArgumentException(result);
    }

    private List<ValidateMsg> validate(List<ValidateConfig> validateConfigs, Map<String, Object> params, Class<?> group) {
        return ValidateUtil.handleValidateData(params, validateConfigs.stream().filter(a -> {
            Object[] columnGroups = a.getValidateGroups();
            return columnGroups == null || ArrayUtils.contains((Object[])columnGroups, (Object)group);
        }).collect(Collectors.toList()));
    }

    private ButtonType byUrl(HttpServletRequest request) throws NotFoundRequestMethodException {
        String path = request.getRequestURI();
        Table table = this.templateService.getTableByUrl(path);
        String urlSuffix = path.substring(table.getUrl().length());
        String mapping = null;
        ButtonType result = null;
        switch (RequestMethod.valueOf((String)request.getMethod().toUpperCase(Locale.ROOT))) {
            case DELETE: {
                if (this.pathMatcher.match(this.deleteById, urlSuffix)) {
                    result = ButtonType.ROW_DELETE;
                    mapping = this.deleteById;
                    break;
                }
                if (!this.pathMatcher.match(this.deleteByIds, urlSuffix)) break;
                result = ButtonType.DELETE;
                mapping = this.deleteByIds;
                break;
            }
            case POST: {
                if (this.pathMatcher.match(this.save, urlSuffix)) {
                    result = ButtonType.ADD;
                    mapping = this.save;
                    break;
                }
                if (this.pathMatcher.match(this.query, urlSuffix)) {
                    result = ButtonType.PAGE;
                    mapping = this.query;
                    break;
                }
                if (this.pathMatcher.match(this.page, urlSuffix)) {
                    result = ButtonType.PAGE;
                    mapping = this.page;
                    break;
                }
                if (this.pathMatcher.match(this.upload, urlSuffix)) {
                    result = ButtonType.UPLOAD;
                    mapping = this.upload;
                    break;
                }
                if (this.pathMatcher.match(this.download, urlSuffix)) {
                    result = ButtonType.DOWNLOAD;
                    mapping = this.download;
                    break;
                }
                if (this.pathMatcher.match(this.template, urlSuffix)) {
                    result = ButtonType.TEMPLATE;
                    mapping = this.template;
                    break;
                }
                if (!this.pathMatcher.match(this.tree, urlSuffix)) break;
                result = ButtonType.TREE;
                mapping = this.tree;
                break;
            }
            case PUT: {
                if (!this.pathMatcher.match(this.update, urlSuffix)) break;
                result = ButtonType.ROW_UPDATE;
                mapping = this.update;
                break;
            }
            case GET: {
                if (this.pathMatcher.match(this.queryById, urlSuffix)) {
                    result = ButtonType.ROW_DETAIL;
                    mapping = this.queryById;
                    break;
                }
                if (this.pathMatcher.match(this.download, urlSuffix)) {
                    result = ButtonType.DOWNLOAD;
                    mapping = this.download;
                    break;
                }
                if (this.pathMatcher.match(this.template, urlSuffix)) {
                    result = ButtonType.TEMPLATE;
                    mapping = this.template;
                    break;
                }
                if (!this.pathMatcher.match(this.tree, urlSuffix)) break;
                result = ButtonType.TREE;
                mapping = this.tree;
                break;
            }
        }
        if (result != null && mapping != null) {
            RequestWrapper requestWrapper = (RequestWrapper)WebUtils.getNativeRequest((ServletRequest)request, RequestWrapper.class);
            requestWrapper.extendInParam((Map)Maps.newHashMap((Map)this.pathMatcher.extractUriTemplateVariables(mapping, urlSuffix)));
            return result;
        }
        throw new NotFoundRequestMethodException();
    }
}

