/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.service;

import cloud.agileframework.abstractbusiness.pojo.entity.IBaseEntity;
import cloud.agileframework.abstractbusiness.pojo.vo.BaseInParamVo;
import cloud.agileframework.abstractbusiness.pojo.vo.IBaseOutParamVo;
import cloud.agileframework.abstractbusiness.service.IBaseService;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.mvc.annotation.Mapping;
import cloud.agileframework.mvc.base.RETURN;
import cloud.agileframework.mvc.param.AgileParam;
import cloud.agileframework.spring.util.BeanUtil;
import cloud.agileframework.validate.annotation.Validate;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMethod;

public interface IBaseDeleteService<E extends IBaseEntity, I extends BaseInParamVo, O extends IBaseOutParamVo>
extends IBaseService<E, I, O> {
    public static final String ID = "id";

    @Validate(value="id", nullable=false)
    @Mapping(value={"${agile.base-service.deleteById:/{id}}"}, method={RequestMethod.DELETE})
    default public RETURN deleteById() throws Exception {
        IBaseDeleteService service = (IBaseDeleteService)BeanUtil.getApplicationContext().getBean(this.getClass());
        service.delete((String)AgileParam.getInParam((String)ID, String.class));
        return RETURN.SUCCESS;
    }

    default public void delete(String id) throws Exception {
        if (this.dataManager() != null) {
            this.dataManager().sync().deleteById(id);
            return;
        }
        this.genericService().deleteById(id, this.getEntityClass());
    }

    @Validate(nullable=false)
    @Mapping(value={"${agile.base-service.deleteByIds:}"}, method={RequestMethod.DELETE})
    default public RETURN deleteByIds() throws Exception {
        IBaseDeleteService service = (IBaseDeleteService)BeanUtil.getApplicationContext().getBean(this.getClass());
        service.delete((List)AgileParam.getInParam((String)ID, (TypeReference)new TypeReference<List<String>>(){}));
        return RETURN.SUCCESS;
    }

    default public void delete(List<String> ids) throws Exception {
        IBaseDeleteService service = (IBaseDeleteService)BeanUtil.getApplicationContext().getBean(this.getClass());
        if (this.dataManager() != null) {
            for (String id : ids) {
                service.delete(id);
            }
            return;
        }
        this.genericService().deleteByIds(ids, this.getEntityClass());
    }

    @Mapping(value={"${agile.base-service.clean:/all}"}, method={RequestMethod.DELETE})
    default public RETURN clean() throws Exception {
        if (this.dataManager() != null) {
            return RETURN.FAIL;
        }
        this.genericService().clean(this.getEntityClass());
        return RETURN.SUCCESS;
    }
}

