/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.controller;

import cloud.agileframework.abstractbusiness.controller.IBaseController;
import cloud.agileframework.abstractbusiness.pojo.entity.IBaseEntity;
import cloud.agileframework.abstractbusiness.pojo.vo.BaseInParamVo;
import cloud.agileframework.abstractbusiness.pojo.vo.IBaseOutParamVo;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.mvc.annotation.AgileInParam;
import cloud.agileframework.mvc.base.RETURN;
import cloud.agileframework.mvc.param.AgileReturn;
import cloud.agileframework.security.filter.login.CustomerUserDetails;
import cloud.agileframework.spring.util.SecurityUtil;
import cloud.agileframework.validate.annotation.Validate;
import cloud.agileframework.validate.group.Update;
import java.util.Date;
import javax.validation.groups.Default;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.bind.annotation.PutMapping;

public interface IBaseUpdateController<E extends IBaseEntity, I extends BaseInParamVo, O extends IBaseOutParamVo>
extends IBaseController<E, O> {
    @Validate(value="id", nullable=false)
    @PutMapping(value={"${agile.base-service.update:}"})
    default public RETURN update(@AgileInParam I inParam) throws Exception {
        this.genericService().validate(inParam, Default.class, Update.class);
        IBaseEntity data = (IBaseEntity)ObjectUtil.to(inParam, (TypeReference)new TypeReference(this.getEntityClass()));
        this.genericService().validateEntityExists(data);
        this.genericService().validateEntity(data, Default.class, Update.class);
        try {
            data.setUpdateTime(new Date());
            UserDetails currentUser = SecurityUtil.currentUser();
            if (currentUser instanceof CustomerUserDetails) {
                data.setUpdateUser(((CustomerUserDetails)currentUser).id());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        AgileReturn.add((String)"result", this.toSingleOutVo(this.genericService().updateData(data)));
        return RETURN.SUCCESS;
    }
}

