/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.service;

import cloud.agileframework.abstractbusiness.pojo.EntityExistsException;
import cloud.agileframework.abstractbusiness.pojo.entity.IBaseEntity;
import cloud.agileframework.abstractbusiness.pojo.vo.BaseInParamVo;
import cloud.agileframework.abstractbusiness.pojo.vo.IBaseOutParamVo;
import cloud.agileframework.abstractbusiness.service.GenericService;
import cloud.agileframework.abstractbusiness.service.IBaseService;
import cloud.agileframework.common.util.collection.TreeBase;
import cloud.agileframework.dictionary.DictionaryDataBase;
import cloud.agileframework.dictionary.util.DictionaryUtil;
import cloud.agileframework.mvc.annotation.AgileInParam;
import cloud.agileframework.mvc.annotation.Mapping;
import cloud.agileframework.mvc.base.RETURN;
import cloud.agileframework.mvc.exception.AgileArgumentException;
import cloud.agileframework.mvc.exception.NoSuchRequestServiceException;
import cloud.agileframework.mvc.param.AgileParam;
import cloud.agileframework.mvc.param.AgileReturn;
import cloud.agileframework.validate.ValidateMsg;
import cloud.agileframework.validate.annotation.Validate;
import cloud.agileframework.validate.group.PageQuery;
import cloud.agileframework.validate.group.Query;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.RequestMethod;

public interface IBaseQueryService<E extends IBaseEntity, I extends BaseInParamVo, O extends IBaseOutParamVo>
extends IBaseService<E, I, O> {
    @Mapping(value={"${agile.base-service.query:/list}"}, method={RequestMethod.POST})
    default public RETURN list() throws Exception {
        BaseInParamVo inParam = (BaseInParamVo)AgileParam.getInParam(this.getInVoClass());
        List<?> result = this.list(inParam);
        AgileReturn.add((String)"result", result);
        return RETURN.SUCCESS;
    }

    default public List<?> list(I inParam) throws Exception {
        List list = this.list(inParam, this.getEntityClass(), this.getOutVoClass());
        for (IBaseOutParamVo vo : list) {
            this.handingListVo(vo);
        }
        return list;
    }

    default public <J, T> List<T> list(I inParam, Class<J> queryBy, Class<T> outBy) throws Exception {
        String sql;
        if (inParam != null) {
            inParam.validate(Query.class);
        }
        List<T> list = (sql = this.parseOrder((BaseInParamVo)inParam, this.listSql())) != null ? this.genericService().list(queryBy, outBy, inParam, sql) : this.genericService().list(queryBy, outBy, inParam);
        return list;
    }

    @Validate(beanClass=BaseInParamVo.class)
    @Mapping(value={"${agile.base-service.page:/{pageNum}/{pageSize}}"}, method={RequestMethod.POST})
    default public RETURN page() throws Exception {
        BaseInParamVo inParam = (BaseInParamVo)AgileParam.getInParam(this.getInVoClass());
        Page<?> result = this.page(inParam);
        AgileReturn.add((String)"result", result);
        return RETURN.SUCCESS;
    }

    default public Page<?> page(I inParam) throws Exception {
        Page page = this.page(inParam, this.getEntityClass(), this.getOutVoClass());
        for (IBaseOutParamVo vo : page.getContent()) {
            this.handingListVo(vo);
        }
        return page;
    }

    default public <J, T> Page<T> page(I inParam, Class<J> queryBy, Class<T> outBy) throws Exception {
        if (inParam == null) {
            throw new AgileArgumentException((List)Lists.newArrayList((Object[])new ValidateMsg[]{ValidateMsg.builder().item("pageNum").message("\u5fc5\u586b").build(), ValidateMsg.builder().item("pageSize").message("\u5fc5\u586b").build()}));
        }
        inParam.validate(PageQuery.class);
        String sql = this.parseOrder((BaseInParamVo)inParam, this.listSql());
        Page<T> page = sql != null ? this.genericService().page(queryBy, outBy, inParam, sql) : this.genericService().page(queryBy, outBy, inParam);
        return page;
    }

    @Mapping(value={"${agile.base-service.tree:/tree}"}, method={RequestMethod.GET, RequestMethod.POST})
    default public RETURN tree() throws Exception {
        BaseInParamVo inParam = (BaseInParamVo)AgileParam.getInParam(this.getInVoClass());
        SortedSet<?> result = this.tree(inParam);
        AgileReturn.add((String)"result", result);
        return RETURN.SUCCESS;
    }

    default public SortedSet<?> tree(I inParam) throws Exception {
        return this.tree(inParam, this.getEntityClass(), this.getOutVoClass());
    }

    default public <L extends Serializable, P extends TreeBase<L, P>, J, T> SortedSet<T> tree(I inParam, Class<J> queryBy, Class<T> outBy) throws Exception {
        if (!TreeBase.class.isAssignableFrom(queryBy)) {
            throw new NoSuchRequestServiceException();
        }
        if (inParam != null) {
            inParam.validate(Query.class);
        }
        List<T> list = this.genericService().list(queryBy, outBy, inParam);
        if (!TreeBase.class.isAssignableFrom(outBy)) {
            throw new AgileArgumentException("\u5982\u679c\u662f\u6811\u5f62\u7ed3\u6784\u67e5\u8be2\uff0coutBy\u5fc5\u987b\u7ee7\u627f\u4e8eTreeBase");
        }
        if (this.getOutVoClass().isAssignableFrom(outBy)) {
            for (T t : list) {
                this.handingListVo((IBaseOutParamVo)t);
            }
        }
        ArrayList<T> result = new ArrayList<T>(list);
        Serializable rootParentId = (Serializable)outBy.getMethod("rootParentId", new Class[0]).invoke(null, new Object[0]);
        return new TreeSet<T>(this.genericService().tree(result, rootParentId));
    }

    @Validate(value="id", nullable=false)
    @Mapping(value={"${agile.base-service.queryById:/{id}}"}, method={RequestMethod.GET})
    default public RETURN queryById(@AgileInParam(value="id") String id) throws Exception {
        Object result = this.queryOne(id);
        AgileReturn.add((String)"result", (Object)result);
        return RETURN.SUCCESS;
    }

    default public Object queryOne(String id) throws Exception {
        IBaseOutParamVo data = (IBaseOutParamVo)this.queryOne(id, this.getEntityClass(), this.getOutVoClass());
        this.handingDetailVo(data);
        return data;
    }

    default public <T, J> T queryOne(String id, Class<J> queryBy, Class<T> outBy) throws Exception {
        T result;
        if (this.dataManager() != null) {
            DictionaryDataBase dic = DictionaryUtil.findById((String)this.dataManager().dataSource(), (String)id);
            result = GenericService.to(GenericService.to(dic, queryBy), outBy);
        } else {
            result = this.detailSql() == null ? GenericService.to(this.dao().findOne(queryBy, (Object)id), outBy) : GenericService.to(this.genericService().queryOne(queryBy, id, this.detailSql(), "id"), outBy);
        }
        if (result == null) {
            throw new EntityExistsException(id);
        }
        return result;
    }

    default public String listSql() {
        return null;
    }

    default public String detailSql() {
        return null;
    }

    default public void handingListVo(O vo) throws Exception {
    }

    default public void handingDetailVo(O vo) throws Exception {
    }

    default public String parseOrder(BaseInParamVo inParam, String sql) {
        if (inParam == null) {
            return sql;
        }
        return inParam.parseOrder(sql);
    }
}

