/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.service;

import cloud.agileframework.abstractbusiness.pojo.entity.IBaseEntity;
import cloud.agileframework.abstractbusiness.pojo.vo.BaseInParamVo;
import cloud.agileframework.abstractbusiness.pojo.vo.IBaseOutParamVo;
import cloud.agileframework.abstractbusiness.service.IBaseService;
import cloud.agileframework.dictionary.DictionaryDataBase;
import cloud.agileframework.mvc.annotation.Mapping;
import cloud.agileframework.mvc.base.RETURN;
import cloud.agileframework.mvc.exception.AgileArgumentException;
import cloud.agileframework.mvc.param.AgileParam;
import cloud.agileframework.security.filter.login.CustomerUserDetails;
import cloud.agileframework.spring.util.SecurityUtil;
import cloud.agileframework.validate.annotation.Validate;
import cloud.agileframework.validate.group.Update;
import java.util.Date;
import javax.validation.groups.Default;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.bind.annotation.RequestMethod;

public interface IBaseUpdateService<E extends IBaseEntity, I extends BaseInParamVo, O extends IBaseOutParamVo>
extends IBaseService<E, I, O> {
    @Validate(nullable=false)
    @Mapping(value={"${agile.base-service.update:}"}, method={RequestMethod.PUT})
    default public RETURN update() throws Exception {
        BaseInParamVo inParam = (BaseInParamVo)AgileParam.getInParam(this.getInVoClass());
        if (inParam == null) {
            throw new AgileArgumentException("\u5165\u53c2\u4e2d\u6ca1\u63d0\u53d6\u5230\u6709\u6548\u6570\u636e");
        }
        this.update(inParam);
        return RETURN.SUCCESS;
    }

    default public void update(I inParam) throws Exception {
        inParam.validate(Default.class, Update.class);
        IBaseEntity data = (IBaseEntity)inParam.to(this.getEntityClass());
        data.validate(Default.class, Update.class);
        this.genericService().validateEntityExists(data);
        try {
            data.setUpdateTime(new Date());
            UserDetails currentUser = SecurityUtil.currentUser();
            if (currentUser instanceof CustomerUserDetails) {
                data.setUpdateUser(((CustomerUserDetails)currentUser).id());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.dataManager() != null) {
            this.dataManager().sync().updateOfNotNull((DictionaryDataBase)data);
        } else {
            this.genericService().updateData(data);
        }
    }
}

