/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.service;

import cloud.agileframework.abstractbusiness.annotation.Excel;
import cloud.agileframework.abstractbusiness.annotation.ExcelDeserialize;
import cloud.agileframework.abstractbusiness.annotation.ExcelSerialize;
import cloud.agileframework.abstractbusiness.pojo.entity.IBaseEntity;
import cloud.agileframework.abstractbusiness.pojo.vo.BaseInParamVo;
import cloud.agileframework.abstractbusiness.pojo.vo.IBaseOutParamVo;
import cloud.agileframework.abstractbusiness.service.IBaseQueryService;
import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.file.FileUtil;
import cloud.agileframework.common.util.file.ResponseFile;
import cloud.agileframework.common.util.file.poi.CellInfo;
import cloud.agileframework.common.util.file.poi.ExcelFile;
import cloud.agileframework.common.util.file.poi.POIUtil;
import cloud.agileframework.common.util.file.poi.SheetData;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.dictionary.util.ConvertDicAnnotation;
import cloud.agileframework.mvc.annotation.AgileInParam;
import cloud.agileframework.mvc.annotation.Mapping;
import cloud.agileframework.mvc.base.RETURN;
import cloud.agileframework.mvc.exception.AgileArgumentException;
import cloud.agileframework.mvc.param.AgileParam;
import cloud.agileframework.mvc.param.AgileReturn;
import cloud.agileframework.spring.util.BeanUtil;
import cloud.agileframework.spring.util.MultipartFileUtil;
import cloud.agileframework.spring.util.POIUtilOfMultipartFile;
import cloud.agileframework.validate.ValidateMsg;
import cloud.agileframework.validate.ValidateUtil;
import cloud.agileframework.validate.group.Insert;
import cloud.agileframework.validate.group.Query;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.NoSuchFileException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

public interface IBaseFileService<E extends IBaseEntity, I extends BaseInParamVo, O extends IBaseOutParamVo>
extends IBaseQueryService<E, I, O> {
    @Mapping(value={"${agile.base-service.upload:/upload}", "/import"}, method={RequestMethod.POST})
    default public RETURN upload(@AgileInParam(value="file") MultipartFile file) throws Exception {
        return this.upload(file, false);
    }

    default public RETURN upload(MultipartFile file, boolean exportAllIfError) throws Exception {
        Set annotations = ClassUtil.getAllFieldAnnotation(this.getInVoClass(), Excel.class);
        List cellInfos = annotations.stream().map(IBaseFileService::getCellInfo).collect(Collectors.toList());
        ArrayList data = Lists.newArrayList();
        TypeReference typeReference = new TypeReference(this.getInVoClass());
        Workbook workbook = POIUtilOfMultipartFile.readFile((MultipartFile)file);
        for (Sheet sheet : workbook) {
            POIUtil.readColumnInfo(cellInfos, (Sheet)sheet);
            int rowTotal = sheet.getLastRowNum() - 1;
            Integer max = (Integer)BeanUtil.getApplicationContext().getEnvironment().getProperty("agile.base-service.importMaxNum", Integer.class, (Object)500);
            if (rowTotal > max) {
                throw new AgileArgumentException("\u6700\u5927\u53ea\u5141\u8bb8\u5bfc\u5165" + max + "\u6761\u6570\u636e");
            }
            int n = sheet.getLastRowNum();
            int rowNum = 1;
            while (rowNum <= n) {
                Row row = sheet.getRow(rowNum++);
                BaseInParamVo rowData = (BaseInParamVo)POIUtil.readRow((TypeReference)typeReference, cellInfos, (Row)row, (Workbook)workbook);
                ConvertDicAnnotation.cover((Object)rowData);
                data.add(rowData);
            }
        }
        ArrayList success = Lists.newArrayList();
        ArrayList error = Lists.newArrayList();
        List<ProxyData<I>> allData = data.stream().map(ProxyData::new).collect(Collectors.toList());
        for (ProxyData proxyData : allData) {
            List<ValidateMsg> validateMsg = this.validateRowData(data, (BaseInParamVo)proxyData.in);
            proxyData.setMsg(validateMsg);
            if (validateMsg.isEmpty()) {
                success.add(proxyData);
                continue;
            }
            error.add(proxyData);
        }
        if (error.isEmpty()) {
            this.handleSuccessData(success.stream().map(a -> (BaseInParamVo)((ProxyData)a).in).collect(Collectors.toList()));
            return RETURN.SUCCESS;
        }
        if (exportAllIfError) {
            this.handleErrorData(allData);
        } else {
            this.handleErrorData(error);
        }
        return RETURN.PARAMETER_ERROR;
    }

    default public List<ValidateMsg> validateRowData(List<I> data, I rowData) throws Exception {
        return ValidateUtil.validate(rowData, (Class[])new Class[]{Insert.class});
    }

    default public void handleSuccessData(List<I> data) throws Exception {
        TypeReference toClass = new TypeReference<List<E>>(){};
        ParameterizedType parameterizedType = (ParameterizedType)toClass.getType();
        parameterizedType = TypeUtils.parameterizeWithOwner((Type)parameterizedType.getOwnerType(), (Class)((Class)parameterizedType.getRawType()), (Type[])new Type[]{this.getEntityClass()});
        toClass.replace((Type)parameterizedType);
        this.genericService().saveDataWithNewTransaction((List)ObjectUtil.to(data, (TypeReference)toClass));
    }

    default public void handleErrorData(List<ProxyData<I>> proxyData) throws Exception {
        this.exportExcel(proxyData);
    }

    default public void exportExcel(List<ProxyData<I>> proxyData) throws Exception {
        Workbook workbook;
        Object templateFile = this.template();
        if (templateFile instanceof ResponseFile) {
            workbook = POIUtil.readFile((String)((ResponseFile)templateFile).getFileName(), (InputStream)((ResponseFile)templateFile).getInputStream());
        } else if (templateFile instanceof ExcelFile) {
            workbook = ((ExcelFile)templateFile).getWorkbook();
        } else {
            throw new AgileArgumentException("\u672a\u627e\u5230\u5408\u9002\u7684\u9519\u8bef\u6570\u636e\u5b58\u50a8\u6587\u4ef6\u683c\u5f0f");
        }
        Set annotations = ClassUtil.getAllFieldAnnotation(this.getInVoClass(), Excel.class);
        List cellInfos = annotations.stream().map(IBaseFileService::getCellInfo).collect(Collectors.toList());
        for (Sheet sheet : workbook) {
            POIUtil.readColumnInfo(cellInfos, (Sheet)sheet);
            for (int rowNum = 0; rowNum < proxyData.size(); ++rowNum) {
                ProxyData<I> proxyDataRow = proxyData.get(rowNum);
                Map<String, ValidateMsg> map = proxyDataRow.getMsg().stream().collect(Collectors.toMap(ValidateMsg::getItem, row -> row));
                Row row2 = sheet.createRow(rowNum + 1);
                for (CellInfo cellInfo : cellInfos) {
                    if (cellInfo.getSort() < 0) continue;
                    String columnKey = cellInfo.getKey();
                    ValidateMsg error = map.get(columnKey);
                    Cell cell = row2.createCell(cellInfo.getSort());
                    if (error == null) {
                        Object value = ObjectUtil.getFieldValue((Object)((ProxyData)proxyDataRow).in, (String)columnKey);
                        String text = value == null ? "" : value.toString();
                        POIUtil.addCellValue((Workbook)workbook, (Cell)cell, (String)text, (Font)workbook.createFont());
                        continue;
                    }
                    Font font = workbook.createFont();
                    font.setColor(IndexedColors.RED.getIndex());
                    Object itemValue = error.getItemValue();
                    CellStyle style = workbook.createCellStyle();
                    style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    style.setFillForegroundColor(IndexedColors.WHITE.getIndex());
                    style.setBorderBottom(BorderStyle.THICK);
                    style.setBottomBorderColor(IndexedColors.RED1.getIndex());
                    style.setBorderLeft(BorderStyle.THICK);
                    style.setLeftBorderColor(IndexedColors.RED1.getIndex());
                    style.setBorderRight(BorderStyle.THICK);
                    style.setRightBorderColor(IndexedColors.RED1.getIndex());
                    style.setBorderTop(BorderStyle.THICK);
                    style.setTopBorderColor(IndexedColors.RED1.getIndex());
                    cell.setCellStyle(style);
                    POIUtil.addCellValue((Workbook)workbook, (Cell)cell, (String)(itemValue == null ? "" : itemValue.toString()), (Font)font);
                    POIUtil.addComment((Workbook)workbook, (Cell)cell, (String)error.getMessage());
                }
            }
        }
        AgileReturn.add((Object)new ExcelFile("\u5bfc\u5165\u5931\u8d25\u6570\u636e", workbook));
    }

    @Mapping(value={"${agile.base-service.download:/download}", "/export"}, method={RequestMethod.POST, RequestMethod.GET})
    default public ExcelFile download() throws Exception {
        BaseInParamVo inParam = (BaseInParamVo)AgileParam.getInParam(this.getInVoClass());
        this.genericService().validate(inParam, Query.class);
        String sql = this.parseOrder(inParam, this.listSql());
        List list = sql != null ? this.genericService().list(this.getEntityClass(), inParam, sql) : this.genericService().list(this.getEntityClass(), inParam);
        List result = this.toOutVo(list);
        Set remarks = ClassUtil.getAllFieldAnnotation(this.getOutVoClass(), Excel.class);
        List cellInfos = remarks.stream().map(IBaseFileService::getCellInfo).collect(Collectors.toList());
        Workbook workbook = POIUtil.creatExcel((POIUtil.VERSION)this.version(), (SheetData[])new SheetData[]{SheetData.builder().setCells(cellInfos).setData((List)((JSONArray)JSON.toJSON(result))).build()});
        return new ExcelFile(this.fileName(), workbook);
    }

    @Mapping(value={"${agile.base-service.template:/template}"}, method={RequestMethod.GET, RequestMethod.POST})
    default public Object template() throws Exception {
        try {
            File file;
            String filePath = this.templatePath();
            if (filePath.startsWith("classpath:")) {
                String substring = filePath.substring(10);
                InputStream stream = this.getClass().getResourceAsStream(FileUtil.parseClassPath((String)substring));
                if (stream == null) {
                    throw new NoSuchFileException(filePath);
                }
                file = new File(FileUtil.parseFilePath((String)(MultipartFileUtil.getTempPath() + substring)));
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)file);
            } else {
                filePath = URLDecoder.decode(filePath, Charset.defaultCharset().name());
                file = new File(filePath);
            }
            if (!file.exists()) {
                throw new NoSuchFileException(filePath);
            }
            return new ResponseFile(file.getName(), file);
        }
        catch (NoSuchFileException e) {
            Set remarks = ClassUtil.getAllFieldAnnotation(this.getInVoClass(), Excel.class);
            List cellInfos = remarks.stream().map(IBaseFileService::getCellInfo).collect(Collectors.toList());
            Workbook workbook = POIUtil.creatExcel((POIUtil.VERSION)this.version(), (SheetData[])new SheetData[]{SheetData.builder().setCells(cellInfos).build()});
            return new ExcelFile(this.fileName(), workbook);
        }
    }

    public static CellInfo getCellInfo(ClassUtil.Target<Excel> target) {
        CellInfo.Builder builder = CellInfo.builder().key(target.getMember().getName()).name(((Excel)target.getAnnotation()).name().trim()).sort(((Excel)target.getAnnotation()).sort()).type(((Excel)target.getAnnotation()).type()).require(((Excel)target.getAnnotation()).require());
        try {
            Class<? extends ExcelSerialize> serializeClass = ((Excel)target.getAnnotation()).serialize();
            if (ExcelSerialize.class != serializeClass) {
                ExcelSerialize obj = (ExcelSerialize)ClassUtil.newInstance(serializeClass);
                Method method = serializeClass.getMethod("to", Object.class);
                builder.serialize(a -> {
                    try {
                        return method.invoke((Object)obj, a);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                });
            } else if (IBaseFileService.getType(target) == Date.class && !StringUtils.isBlank((CharSequence)((Excel)target.getAnnotation()).format())) {
                builder.serialize(a -> {
                    if (a == null) {
                        return null;
                    }
                    try {
                        SimpleDateFormat simple = new SimpleDateFormat(((Excel)target.getAnnotation()).format());
                        return simple.format((Date)a);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            Class<? extends ExcelDeserialize> deserializeClass = ((Excel)target.getAnnotation()).deserialize();
            if (ExcelDeserialize.class != deserializeClass) {
                ExcelDeserialize obj = (ExcelDeserialize)ClassUtil.newInstance(deserializeClass);
                Method method = deserializeClass.getMethod("to", Object.class);
                builder.deserialize(a -> {
                    try {
                        return method.invoke((Object)obj, a);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                });
            } else if (IBaseFileService.getType(target) == Date.class && !StringUtils.isBlank((CharSequence)((Excel)target.getAnnotation()).format())) {
                builder.deserialize(a -> {
                    try {
                        if (a instanceof Date || a == null) {
                            return a;
                        }
                        SimpleDateFormat simple = new SimpleDateFormat(((Excel)target.getAnnotation()).format());
                        return simple.parse(a.toString());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return builder.build();
    }

    public static Class<?> getType(ClassUtil.Target<Excel> target) {
        Member member = target.getMember();
        if (member instanceof Field) {
            return ((Field)member).getType();
        }
        if (member instanceof Method) {
            return ((Method)member).getReturnType();
        }
        return Object.class;
    }

    default public String fileName() {
        return "\u4e0b\u8f7d\u6587\u4ef6";
    }

    default public String templatePath() throws NoSuchFileException {
        throw new NoSuchFileException("\u672a\u914d\u7f6e\u6a21\u677f\u6587\u4ef6\u76ee\u5f55");
    }

    default public POIUtil.VERSION version() {
        return POIUtil.VERSION.V2007;
    }

    public static class ProxyData<I> {
        private I in;
        private List<ValidateMsg> msg;

        public ProxyData(I in) {
            this.in = in;
        }

        public I getIn() {
            return this.in;
        }

        public List<ValidateMsg> getMsg() {
            return this.msg;
        }

        public void setIn(I in) {
            this.in = in;
        }

        public void setMsg(List<ValidateMsg> msg) {
            this.msg = msg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProxyData)) {
                return false;
            }
            ProxyData other = (ProxyData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            I this$in = this.getIn();
            I other$in = other.getIn();
            if (this$in == null ? other$in != null : !this$in.equals(other$in)) {
                return false;
            }
            List<ValidateMsg> this$msg = this.getMsg();
            List<ValidateMsg> other$msg = other.getMsg();
            return !(this$msg == null ? other$msg != null : !((Object)this$msg).equals(other$msg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProxyData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            I $in = this.getIn();
            result = result * 59 + ($in == null ? 43 : $in.hashCode());
            List<ValidateMsg> $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : ((Object)$msg).hashCode());
            return result;
        }

        public String toString() {
            return "IBaseFileService.ProxyData(in=" + this.getIn() + ", msg=" + this.getMsg() + ")";
        }
    }
}

