/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.service;

import cloud.agileframework.abstractbusiness.controller.BaseBusinessService;
import cloud.agileframework.abstractbusiness.pojo.EntityExistsException;
import cloud.agileframework.abstractbusiness.pojo.entity.IBaseEntity;
import cloud.agileframework.abstractbusiness.pojo.vo.BaseInParamVo;
import cloud.agileframework.abstractbusiness.service.ISecurityService;
import cloud.agileframework.common.DataException;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.collection.TreeBase;
import cloud.agileframework.common.util.collection.TreeUtil;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.data.common.dao.BaseDao;
import cloud.agileframework.dictionary.util.TranslateException;
import cloud.agileframework.jpa.dao.Dao;
import cloud.agileframework.mvc.exception.AgileArgumentException;
import cloud.agileframework.spring.util.BeanUtil;
import cloud.agileframework.validate.ValidateMsg;
import cloud.agileframework.validate.ValidateUtil;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class GenericService {
    private final BaseDao dao;
    private final ISecurityService security;

    public GenericService(BaseDao dao, ISecurityService security) {
        this.dao = dao;
        this.security = security;
    }

    public BaseDao dao() {
        return this.dao;
    }

    public ISecurityService security() {
        return this.security;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public <E extends IBaseEntity> void saveDataWithNewTransaction(List<E> data) throws NoSuchFieldException, IllegalAccessException, DataException {
        this.saveData((E)((Object)data));
    }

    @Transactional(rollbackFor={Exception.class})
    public <E extends IBaseEntity> void saveData(List<E> data) {
        for (IBaseEntity node : data) {
            Object v = this.dao().getId((Object)node);
            if (StringUtils.isBlank((CharSequence)String.valueOf(v))) {
                this.dao().setId((Object)node, null);
            }
            if (node.getCreateUser() != null) continue;
            node.setCreateUser(this.security().currentUser());
        }
        this.dao().save(data);
    }

    @Transactional(rollbackFor={Exception.class})
    public <E extends IBaseEntity> E saveData(E data) {
        Object v = this.dao().getId(data);
        if (StringUtils.isBlank((CharSequence)String.valueOf(v))) {
            this.dao().setId(data, null);
        }
        if (data.getCreateUser() == null) {
            data.setCreateUser(this.security().currentUser());
        }
        return (E)((IBaseEntity)this.dao().saveAndReturn(data));
    }

    @Transactional(rollbackFor={Exception.class})
    public <E extends IBaseEntity> boolean deleteById(Object id, Class<E> javaType) {
        return this.dao().deleteById(javaType, id);
    }

    @Transactional(rollbackFor={Exception.class})
    public <E extends IBaseEntity> void deleteByIds(List<String> id, Class<E> javaType) {
        this.dao().deleteInBatch(javaType, id);
    }

    @Transactional(rollbackFor={Exception.class})
    public <E extends IBaseEntity> E updateData(E data) {
        if (data != null && data.getUpdateUser() == null) {
            data.setUpdateUser(this.security().currentUser());
        }
        return (E)((IBaseEntity)this.dao().updateOfNotNull(data));
    }

    public <I extends BaseInParamVo, E extends IBaseEntity> List<E> list(Class<E> entityClass, I inParam) {
        IBaseEntity data = (IBaseEntity)ObjectUtil.to(inParam, (TypeReference)new TypeReference(entityClass));
        if (data == null) {
            return this.dao().findAllByClass(entityClass, inParam.sort());
        }
        return this.dao().findAll((Object)data, inParam.sort());
    }

    public <I extends BaseInParamVo, V> List<V> list(Class<V> outVoClass, I inParam, String sql) {
        if (inParam == null) {
            return this.dao().findBySQL(sql, outVoClass, new Object[]{Maps.newHashMap()});
        }
        return this.dao().findBySQL(sql, outVoClass, new Object[]{inParam});
    }

    public <E extends IBaseEntity> E queryById(Class<E> data, Object id) {
        return (E)((IBaseEntity)this.dao().findOne(data, id));
    }

    public <V, E extends IBaseEntity> V queryOne(Class<V> outVoClass, Class<E> doClass, String id, String sql, String idPlaceholder) {
        HashMap params = Maps.newHashMap();
        params.put(idPlaceholder, id);
        IBaseEntity data = (IBaseEntity)this.dao().findOne(sql, doClass, new Object[]{params});
        return (V)ObjectUtil.to((Object)data, (TypeReference)new TypeReference(outVoClass));
    }

    public <I extends BaseInParamVo, V> Page<V> page(Class<V> outVoClass, I inParam, String sql) {
        PageRequest pageRequest = PageRequest.of((int)(inParam.getPageNum() - 1), (int)inParam.getPageSize());
        return this.dao().pageBySQL(inParam.parseOrder(sql), pageRequest, outVoClass, new Object[]{inParam});
    }

    public <I extends BaseInParamVo, E extends IBaseEntity> Page<E> page(Class<E> entityClass, I inParam) {
        IBaseEntity data = (IBaseEntity)ObjectUtil.to(inParam, (TypeReference)new TypeReference(entityClass));
        PageRequest pageRequest = PageRequest.of((int)(inParam.getPageNum() - 1), (int)inParam.getPageSize(), (Sort)inParam.sort());
        if (data == null) {
            return this.dao().pageByClass(entityClass, pageRequest);
        }
        return this.dao().page((Object)data, pageRequest);
    }

    @Transactional(rollbackFor={Exception.class})
    public <E extends IBaseEntity> void clean(Class<E> data) {
        this.dao().deleteAllInBatch(data);
    }

    public <I extends Serializable, A extends TreeBase<I, A>> SortedSet<A> tree(List<A> all, I rootParentId) {
        return TreeUtil.createTree(all, rootParentId);
    }

    public void validate(Object pojo, Class<?> ... groups) throws AgileArgumentException {
        List list = ValidateUtil.validate((Object)pojo, (Class[])groups);
        if (!list.isEmpty()) {
            throw new AgileArgumentException(list);
        }
    }

    public void validateEntity(Object pojo, Class<?> ... groups) throws AgileArgumentException {
        List<ValidateMsg> list = BaseBusinessService.toValidateMessages(pojo, groups);
        if (!list.isEmpty()) {
            throw new AgileArgumentException(list);
        }
    }

    public <E extends IBaseEntity> void validateEntityExists(E pojo) throws EntityExistsException, TranslateException {
        Dao dao = (Dao)BeanUtil.getBean(Dao.class);
        Object id = null;
        if (pojo != null) {
            id = dao.getId(pojo);
        }
        if (id == null) {
            return;
        }
        List old = dao.findAllByArrayId(pojo.getClass(), new Object[]{id});
        if (old == null || old.isEmpty()) {
            throw new EntityExistsException(id + "");
        }
    }
}

