/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.pojo.vo;

import cloud.agileframework.common.annotation.Alias;
import cloud.agileframework.common.util.collection.SortInfo;
import cloud.agileframework.validate.group.PageQuery;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.parser.ParserException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.springframework.data.domain.Sort;

public class BaseInParamVo
implements Serializable {
    private List<SortInfo> sortColumn;
    @Alias(value={"page"})
    @NotNull(groups={PageQuery.class})
    private Integer pageNum;
    @NotNull(groups={PageQuery.class})
    private Integer pageSize;

    public String parseOrder(String sql) {
        List<SortInfo> sortInfos = this.getSortColumn();
        if (sortInfos == null || sortInfos.isEmpty()) {
            return sql;
        }
        SQLExpr expr = SQLUtils.toSQLExpr((String)(sql = sql.replaceAll("\\s*;\\s*$", " ")), (DbType)DbType.mysql);
        if (expr instanceof SQLQueryExpr) {
            SQLSelect subQuery = ((SQLQueryExpr)expr).getSubQuery();
            SQLOrderBy orderBy = subQuery.getQueryBlock().getOrderBy();
            if (orderBy == null) {
                orderBy = new SQLOrderBy();
                subQuery.getQueryBlock().setOrderBy(orderBy);
            }
            for (SortInfo sortInfo : sortInfos) {
                SQLSelectOrderByItem order = new SQLSelectOrderByItem(SQLUtils.toSQLExpr((String)sortInfo.getProperty()));
                if (!(order.getExpr() instanceof SQLPropertyExpr) && !(order.getExpr() instanceof SQLIdentifierExpr)) {
                    throw new ParserException();
                }
                order.setType(sortInfo.isSort() ? SQLOrderingSpecification.ASC : SQLOrderingSpecification.DESC);
                orderBy.addItem(order);
            }
            return subQuery.toString();
        }
        return expr.toString();
    }

    public Sort sort() {
        if (this.getSortColumn() == null || this.getSortColumn().isEmpty()) {
            return Sort.unsorted();
        }
        List<SortInfo> sorts = this.getSortColumn();
        List s = sorts.stream().map(sortInfo -> {
            if (sortInfo.isSort()) {
                return Sort.Order.desc((String)sortInfo.getProperty());
            }
            return Sort.Order.asc((String)sortInfo.getProperty());
        }).collect(Collectors.toList());
        return Sort.by(s);
    }

    public List<SortInfo> getSortColumn() {
        return this.sortColumn;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setSortColumn(List<SortInfo> sortColumn) {
        this.sortColumn = sortColumn;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseInParamVo)) {
            return false;
        }
        BaseInParamVo other = (BaseInParamVo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$pageNum = this.getPageNum();
        Integer other$pageNum = other.getPageNum();
        if (this$pageNum == null ? other$pageNum != null : !((Object)this$pageNum).equals(other$pageNum)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        List<SortInfo> this$sortColumn = this.getSortColumn();
        List<SortInfo> other$sortColumn = other.getSortColumn();
        return !(this$sortColumn == null ? other$sortColumn != null : !((Object)this$sortColumn).equals(other$sortColumn));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseInParamVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pageNum = this.getPageNum();
        result = result * 59 + ($pageNum == null ? 43 : ((Object)$pageNum).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        List<SortInfo> $sortColumn = this.getSortColumn();
        result = result * 59 + ($sortColumn == null ? 43 : ((Object)$sortColumn).hashCode());
        return result;
    }

    public String toString() {
        return "BaseInParamVo(sortColumn=" + this.getSortColumn() + ", pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ")";
    }
}

