/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.controller;

import cloud.agileframework.abstractbusiness.pojo.entity.IBaseEntity;
import cloud.agileframework.abstractbusiness.pojo.vo.IBaseOutParamVo;
import cloud.agileframework.abstractbusiness.service.GenericService;
import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.dictionary.util.ConvertDicAnnotation;
import cloud.agileframework.spring.util.BeanUtil;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;

public interface IBaseController<E extends IBaseEntity, O extends IBaseOutParamVo> {
    default public GenericService genericService() {
        return (GenericService)BeanUtil.getBean(GenericService.class);
    }

    default public Class<E> getEntityClass() {
        Type entityClass = ClassUtil.getGeneric(this.getClass(), IBaseController.class, (int)0);
        if (entityClass instanceof Class) {
            return (Class)entityClass;
        }
        throw new ClassCastException("\u5f53\u524d\u7c7b\u4f5c\u4e3a\u53c2\u6570\u5316\u7c7b\u578b\u201cE\u201d\uff0c\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53\u7c7b\u578b");
    }

    default public Class<O> getOutVoClass() {
        Type entityClass = ClassUtil.getGeneric(this.getClass(), IBaseController.class, (int)1);
        if (entityClass instanceof Class) {
            return (Class)entityClass;
        }
        throw new ClassCastException("\u5f53\u524d\u7c7b\u4f5c\u4e3a\u53c2\u6570\u5316\u7c7b\u578b\u201cO\u201d\uff0c\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53\u7c7b\u578b");
    }

    default public List<O> toOutVo(List<E> list) {
        return list.stream().map(this::toSingleOutVo).collect(Collectors.toList());
    }

    default public O toSingleOutVo(E n) {
        if (n == null) {
            return null;
        }
        TypeReference typeReference = new TypeReference(this.getOutVoClass());
        IBaseOutParamVo o = (IBaseOutParamVo)ObjectUtil.to(n, (TypeReference)typeReference);
        if (o == null) {
            return (O)((IBaseOutParamVo)ClassUtil.newInstance(this.getOutVoClass()));
        }
        ConvertDicAnnotation.cover((Object)o);
        return (O)o;
    }
}

