/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.service;

import cloud.agileframework.abstractbusiness.pojo.entity.IBaseEntity;
import cloud.agileframework.abstractbusiness.pojo.vo.BaseInParamVo;
import cloud.agileframework.abstractbusiness.pojo.vo.IBaseOutParamVo;
import cloud.agileframework.abstractbusiness.service.IBaseService;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.dictionary.DictionaryDataBase;
import cloud.agileframework.mvc.annotation.Mapping;
import cloud.agileframework.mvc.base.RETURN;
import cloud.agileframework.mvc.param.AgileParam;
import cloud.agileframework.mvc.param.AgileReturn;
import cloud.agileframework.security.filter.login.CustomerUserDetails;
import cloud.agileframework.spring.util.SecurityUtil;
import cloud.agileframework.validate.group.Insert;
import java.util.Date;
import javax.validation.groups.Default;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.bind.annotation.RequestMethod;

public interface IBaseSaveService<E extends IBaseEntity, I extends BaseInParamVo, O extends IBaseOutParamVo>
extends IBaseService<E, I, O> {
    @Mapping(value={"${agile.base-service.save:}"}, method={RequestMethod.POST})
    default public RETURN save() throws Exception {
        BaseInParamVo inParam = (BaseInParamVo)AgileParam.getInParam(this.getInVoClass());
        return this.save(inParam);
    }

    default public RETURN save(I inParam) throws Exception {
        IBaseEntity data = (IBaseEntity)ObjectUtil.to(inParam, (TypeReference)new TypeReference(this.getEntityClass()));
        this.validate(inParam, Default.class, Insert.class);
        this.validateEntity(data, Default.class, Insert.class);
        try {
            data.setCreateTime(new Date());
            UserDetails currentUser = SecurityUtil.currentUser();
            if (currentUser instanceof CustomerUserDetails) {
                data.setCreateUser(((CustomerUserDetails)currentUser).id());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.dataManager() != null) {
            this.dataManager().sync().add((DictionaryDataBase)data);
            return RETURN.SUCCESS;
        }
        AgileReturn.add((String)"result", this.toSingleOutVo(this.saveData(data)));
        return RETURN.SUCCESS;
    }
}

