/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.service;

import cloud.agileframework.abstractbusiness.pojo.EntityExistsException;
import cloud.agileframework.abstractbusiness.pojo.entity.IBaseEntity;
import cloud.agileframework.abstractbusiness.pojo.vo.BaseInParamVo;
import cloud.agileframework.abstractbusiness.pojo.vo.IBaseOutParamVo;
import cloud.agileframework.abstractbusiness.service.IBaseService;
import cloud.agileframework.common.util.collection.TreeBase;
import cloud.agileframework.dictionary.util.DictionaryUtil;
import cloud.agileframework.mvc.annotation.AgileInParam;
import cloud.agileframework.mvc.annotation.Mapping;
import cloud.agileframework.mvc.annotation.NotAPI;
import cloud.agileframework.mvc.base.RETURN;
import cloud.agileframework.mvc.exception.AgileArgumentException;
import cloud.agileframework.mvc.exception.NoSuchRequestServiceException;
import cloud.agileframework.mvc.param.AgileParam;
import cloud.agileframework.mvc.param.AgileReturn;
import cloud.agileframework.validate.annotation.Validate;
import cloud.agileframework.validate.group.PageQuery;
import cloud.agileframework.validate.group.Query;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.PageImpl;
import org.springframework.web.bind.annotation.RequestMethod;

public interface IBaseQueryService<E extends IBaseEntity, I extends BaseInParamVo, O extends IBaseOutParamVo>
extends IBaseService<E, I, O> {
    @Mapping(value={"${agile.base-service.query:/list}"}, method={RequestMethod.POST})
    default public RETURN list() throws Exception {
        BaseInParamVo inParam = (BaseInParamVo)AgileParam.getInParam(this.getInVoClass());
        return this.list(inParam);
    }

    default public RETURN list(I inParam) throws Exception {
        List result;
        this.validate(inParam, Query.class);
        String sql = this.parseOrder((BaseInParamVo)inParam, this.listSql());
        if (sql != null) {
            result = this.list(this.getOutVoClass(), inParam, sql);
        } else {
            List list = this.list(this.getEntityClass(), inParam);
            result = this.toOutVo(list);
        }
        for (IBaseOutParamVo vo : result) {
            this.handingListVo(vo);
        }
        AgileReturn.add((String)"result", result);
        return RETURN.SUCCESS;
    }

    @Validate(beanClass=BaseInParamVo.class)
    @Mapping(value={"${agile.base-service.page:/{pageNum}/{pageSize}}"}, method={RequestMethod.POST})
    default public RETURN page() throws Exception {
        BaseInParamVo inParam = (BaseInParamVo)AgileParam.getInParam(this.getInVoClass());
        return this.page(inParam);
    }

    default public RETURN page(I inParam) throws Exception {
        this.validate(inParam, PageQuery.class);
        String sql = this.parseOrder((BaseInParamVo)inParam, this.listSql());
        Object page = sql != null ? this.page(this.getOutVoClass(), inParam, sql) : this.page(this.getEntityClass(), inParam);
        PageImpl result = new PageImpl(this.toOutVo(page.getContent()), page.getPageable(), page.getTotalElements());
        for (IBaseOutParamVo vo : result.getContent()) {
            this.handingListVo(vo);
        }
        AgileReturn.add((String)"result", (Object)result);
        return RETURN.SUCCESS;
    }

    @Mapping(value={"${agile.base-service.tree:/tree}"}, method={RequestMethod.GET, RequestMethod.POST})
    default public <L extends Serializable, P extends TreeBase<L, P>> RETURN tree() throws Exception {
        BaseInParamVo inParam = (BaseInParamVo)AgileParam.getInParam(this.getInVoClass());
        return this.tree(inParam);
    }

    default public <L extends Serializable, P extends TreeBase<L, P>> RETURN tree(I inParam) throws Exception {
        if (!TreeBase.class.isAssignableFrom(this.getEntityClass())) {
            throw new NoSuchRequestServiceException();
        }
        this.validate(inParam, Query.class);
        List list = this.list(this.getEntityClass(), inParam);
        if (!TreeBase.class.isAssignableFrom(this.getOutVoClass())) {
            throw new AgileArgumentException("\u5982\u679c\u662f\u6811\u5f62\u7ed3\u6784\u67e5\u8be2\uff0cOutVo\u5fc5\u987b\u7ee7\u627f\u4e8eTreeBase");
        }
        ArrayList result = new ArrayList(this.toOutVo(list));
        Serializable rootParentId = (Serializable)this.getOutVoClass().getMethod("rootParentId", new Class[0]).invoke(null, new Object[0]);
        AgileReturn.add((String)"result", this.tree(result, rootParentId));
        return RETURN.SUCCESS;
    }

    @Validate(value="id", nullable=false)
    @Mapping(value={"${agile.base-service.queryById:/{id}}"}, method={RequestMethod.GET})
    default public RETURN queryById(@AgileInParam(value="id") String id) throws Exception {
        Object result = this.dataManager() != null ? this.toSingleOutVo(DictionaryUtil.findById((String)this.dataManager().dataSource(), (String)id)) : (this.detailSql() == null ? this.toSingleOutVo(this.queryById(this.getEntityClass(), id)) : (IBaseOutParamVo)this.queryOne(this.getOutVoClass(), this.getEntityClass(), id, this.detailSql()));
        if (result == null) {
            throw new EntityExistsException(id);
        }
        this.handingDetailVo(result);
        AgileReturn.add((String)"result", result);
        return RETURN.SUCCESS;
    }

    @NotAPI
    default public String listSql() {
        return null;
    }

    @NotAPI
    default public String detailSql() {
        return null;
    }

    @NotAPI
    default public void handingListVo(O vo) throws Exception {
    }

    @NotAPI
    default public void handingDetailVo(O vo) throws Exception {
    }

    default public String parseOrder(BaseInParamVo inParam, String sql) {
        if (inParam == null) {
            return sql;
        }
        return inParam.parseOrder(sql);
    }
}

