/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.service;

import cloud.agileframework.abstractbusiness.pojo.entity.IBaseEntity;
import cloud.agileframework.abstractbusiness.pojo.vo.BaseInParamVo;
import cloud.agileframework.abstractbusiness.pojo.vo.IBaseOutParamVo;
import cloud.agileframework.abstractbusiness.service.IBaseService;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.dictionary.DictionaryDataBase;
import cloud.agileframework.mvc.annotation.Mapping;
import cloud.agileframework.mvc.base.RETURN;
import cloud.agileframework.mvc.param.AgileParam;
import cloud.agileframework.mvc.param.AgileReturn;
import cloud.agileframework.security.filter.login.CustomerUserDetails;
import cloud.agileframework.spring.util.SecurityUtil;
import cloud.agileframework.validate.annotation.Validate;
import cloud.agileframework.validate.group.Update;
import java.util.Date;
import javax.validation.groups.Default;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.bind.annotation.RequestMethod;

public interface IBaseUpdateService<E extends IBaseEntity, I extends BaseInParamVo, O extends IBaseOutParamVo>
extends IBaseService<E, I, O> {
    @Validate(nullable=false)
    @Mapping(value={"${agile.base-service.update:}"}, method={RequestMethod.PUT})
    default public RETURN update() throws Exception {
        BaseInParamVo inParam = (BaseInParamVo)AgileParam.getInParam(this.getInVoClass());
        return this.update(inParam);
    }

    default public RETURN update(I inParam) throws Exception {
        IBaseEntity data = (IBaseEntity)ObjectUtil.to(inParam, (TypeReference)new TypeReference(this.getEntityClass()));
        this.validate(inParam, Default.class, Update.class);
        this.validateEntityExists(data);
        this.validateEntity(data, Default.class, Update.class);
        try {
            data.setUpdateTime(new Date());
            UserDetails currentUser = SecurityUtil.currentUser();
            if (currentUser instanceof CustomerUserDetails) {
                data.setUpdateUser(((CustomerUserDetails)currentUser).id());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.dataManager() != null) {
            this.dataManager().sync().updateOfNotNull((DictionaryDataBase)data);
            return RETURN.SUCCESS;
        }
        AgileReturn.add((String)"result", this.toSingleOutVo(this.updateData(data)));
        return RETURN.SUCCESS;
    }
}

