/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.service;

import cloud.agileframework.abstractbusiness.pojo.ImportFileFormatException;
import cloud.agileframework.abstractbusiness.pojo.entity.IBaseEntity;
import cloud.agileframework.abstractbusiness.pojo.vo.BaseInParamVo;
import cloud.agileframework.abstractbusiness.pojo.vo.IBaseOutParamVo;
import cloud.agileframework.abstractbusiness.service.IBaseQueryService;
import cloud.agileframework.common.annotation.Remark;
import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.file.FileUtil;
import cloud.agileframework.common.util.file.ResponseFile;
import cloud.agileframework.common.util.file.poi.CellInfo;
import cloud.agileframework.common.util.file.poi.ExcelFile;
import cloud.agileframework.common.util.file.poi.POIUtil;
import cloud.agileframework.common.util.file.poi.SheetData;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.dictionary.util.DictionaryUtil;
import cloud.agileframework.mvc.annotation.AgileInParam;
import cloud.agileframework.mvc.annotation.Mapping;
import cloud.agileframework.mvc.base.RETURN;
import cloud.agileframework.mvc.exception.AgileArgumentException;
import cloud.agileframework.mvc.param.AgileParam;
import cloud.agileframework.mvc.param.AgileReturn;
import cloud.agileframework.spring.util.BeanUtil;
import cloud.agileframework.spring.util.MultipartFileUtil;
import cloud.agileframework.spring.util.POIUtilOfMultipartFile;
import cloud.agileframework.validate.ValidateMsg;
import cloud.agileframework.validate.ValidateUtil;
import cloud.agileframework.validate.group.Insert;
import cloud.agileframework.validate.group.Query;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

public interface IBaseFileService<E extends IBaseEntity, I extends BaseInParamVo, O extends IBaseOutParamVo>
extends IBaseQueryService<E, I, O> {
    @Mapping(value={"${agile.base-service.upload:/upload}", "/import"}, method={RequestMethod.POST})
    default public RETURN upload(@AgileInParam(value="file") MultipartFile file) throws Exception {
        return this.upload(file, false);
    }

    default public RETURN upload(MultipartFile file, boolean exportAllIfError) throws Exception {
        Set remarks = ClassUtil.getAllFieldAnnotation(this.getInVoClass(), Remark.class);
        List cellInfos = remarks.stream().filter(r -> ((Remark)r.getAnnotation()).excelHead()).map(r -> CellInfo.builder().setKey(r.getMember().getName()).setShowName(((Remark)r.getAnnotation()).value()).build()).collect(Collectors.toList());
        ArrayList data = Lists.newArrayList();
        ArrayList errorData = Lists.newArrayList();
        TypeReference typeReference = new TypeReference(this.getInVoClass());
        Workbook workbook = POIUtilOfMultipartFile.readFile((MultipartFile)file);
        for (Sheet sheet : workbook) {
            Integer max;
            List columnInfo = POIUtil.readColumnInfo(cellInfos, (Sheet)sheet);
            if (columnInfo.stream().anyMatch(Objects::isNull)) {
                throw new ImportFileFormatException();
            }
            int rowTotal = sheet.getLastRowNum() - 1;
            if (rowTotal > (max = (Integer)BeanUtil.getApplicationContext().getEnvironment().getProperty("agile.base-service.importMaxNum", Integer.class, (Object)500))) {
                throw new AgileArgumentException("\u6700\u5927\u53ea\u5141\u8bb8\u5bfc\u5165" + max + "\u6761\u6570\u636e");
            }
            int maxRowNum = sheet.getLastRowNum();
            int rowNum = 0;
            while (rowNum <= maxRowNum) {
                if (rowNum == 0) {
                    ++rowNum;
                    continue;
                }
                Row row = sheet.getRow(rowNum);
                BaseInParamVo rowData = (BaseInParamVo)POIUtil.readRow((TypeReference)typeReference, (List)columnInfo, (Row)row);
                if (rowData == null) {
                    ++rowNum;
                    continue;
                }
                DictionaryUtil.cover((Object)rowData);
                List<ValidateMsg> msg = this.validateRowData(rowData);
                if (msg.isEmpty()) {
                    data.add(rowData);
                    if (!exportAllIfError) {
                        sheet.shiftRows(rowNum, maxRowNum, -1);
                        --maxRowNum;
                        continue;
                    }
                    ++rowNum;
                    continue;
                }
                errorData.add(rowData);
                Map<String, ValidateMsg> map = msg.stream().collect(Collectors.toMap(ValidateMsg::getItem, a -> a));
                for (int i = 0; i < columnInfo.size(); ++i) {
                    String columnKey = (String)columnInfo.get(i);
                    ValidateMsg error = map.get(columnKey);
                    if (error == null) continue;
                    Cell cell = row.getCell(i);
                    cell = cell == null ? row.createCell(i) : cell;
                    Font font = workbook.createFont();
                    font.setColor(IndexedColors.RED.getIndex());
                    Object itemValue = error.getItemValue();
                    CellStyle style = workbook.createCellStyle();
                    style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    style.setFillForegroundColor(IndexedColors.WHITE.getIndex());
                    style.setBorderBottom(BorderStyle.THICK);
                    style.setBottomBorderColor(IndexedColors.RED1.getIndex());
                    style.setBorderLeft(BorderStyle.THICK);
                    style.setLeftBorderColor(IndexedColors.RED1.getIndex());
                    style.setBorderRight(BorderStyle.THICK);
                    style.setRightBorderColor(IndexedColors.RED1.getIndex());
                    style.setBorderTop(BorderStyle.THICK);
                    style.setTopBorderColor(IndexedColors.RED1.getIndex());
                    cell.setCellStyle(style);
                    POIUtil.addCellValue((Workbook)workbook, (Cell)cell, (String)(itemValue == null ? "" : itemValue.toString()), (Font)font);
                    POIUtil.addComment((Workbook)workbook, (Cell)cell, (String)error.getMessage());
                }
                ++rowNum;
            }
        }
        if (errorData.isEmpty() || !exportAllIfError) {
            this.handleSuccessData(data);
        }
        if (!errorData.isEmpty()) {
            this.handleErrorData(errorData, workbook);
            return RETURN.PARAMETER_ERROR;
        }
        return RETURN.SUCCESS;
    }

    default public List<ValidateMsg> validateRowData(I rowData) throws Exception {
        return ValidateUtil.validate(rowData, (Class[])new Class[]{Insert.class});
    }

    default public void handleSuccessData(List<I> data) throws Exception {
        TypeReference toClass = new TypeReference<List<E>>(){};
        ParameterizedType parameterizedType = (ParameterizedType)toClass.getType();
        parameterizedType = TypeUtils.parameterizeWithOwner((Type)parameterizedType.getOwnerType(), (Class)((Class)parameterizedType.getRawType()), (Type[])new Type[]{this.getEntityClass()});
        toClass.replace((Type)parameterizedType);
        ((IBaseFileService)Objects.requireNonNull(BeanUtil.getBean(this.getClass()))).saveDataWithNewTransaction((List)ObjectUtil.to(data, (TypeReference)toClass));
    }

    default public void handleErrorData(List<I> errorData, Workbook workbook) throws Exception {
        AgileReturn.add((Object)new ExcelFile("\u5bfc\u5165\u5931\u8d25\u6570\u636e", workbook));
    }

    @Mapping(value={"${agile.base-service.download:/download}", "/export"}, method={RequestMethod.POST, RequestMethod.GET})
    default public ExcelFile download() throws Exception {
        BaseInParamVo inParam = (BaseInParamVo)AgileParam.getInParam(this.getInVoClass());
        this.validate(inParam, Query.class);
        String sql = IBaseQueryService.parseOrder(inParam, this.listSql());
        List<Object> list = sql != null ? this.list(this.getOutVoClass(), inParam, sql) : this.list(this.getEntityClass(), inParam);
        List result = this.toOutVo(list);
        Set remarks = ClassUtil.getAllFieldAnnotation(this.getOutVoClass(), Remark.class);
        List cellInfos = remarks.stream().map(r -> CellInfo.builder().setKey(r.getMember().getName()).setShowName(((Remark)r.getAnnotation()).value()).setSort(((Remark)r.getAnnotation()).sort()).build()).collect(Collectors.toList());
        Workbook workbook = POIUtil.creatExcel((POIUtil.VERSION)this.version(), (SheetData[])new SheetData[]{SheetData.builder().setCells(cellInfos).setData(new ArrayList(result)).build()});
        return new ExcelFile(this.fileName(), workbook);
    }

    @Mapping(value={"${agile.base-service.template:/template}"}, method={RequestMethod.GET, RequestMethod.POST})
    default public Object template() throws Exception {
        try {
            File file;
            String filePath = this.templatePath();
            if (filePath.startsWith("classpath:")) {
                String substring = filePath.substring(10);
                InputStream stream = this.getClass().getResourceAsStream(FileUtil.parseClassPath((String)substring));
                if (stream == null) {
                    throw new NoSuchFileException(filePath);
                }
                file = new File(FileUtil.parseFilePath((String)(MultipartFileUtil.getTempPath() + substring)));
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)file);
            } else {
                filePath = URLDecoder.decode(filePath, Charset.defaultCharset().name());
                file = new File(filePath);
            }
            if (!file.exists()) {
                throw new NoSuchFileException(filePath);
            }
            return new ResponseFile(file.getName(), file);
        }
        catch (NoSuchFileException e) {
            Set remarks = ClassUtil.getAllFieldAnnotation(this.getInVoClass(), Remark.class);
            List cellInfos = remarks.stream().map(r -> CellInfo.builder().setKey(r.getMember().getName()).setShowName(((Remark)r.getAnnotation()).value()).setSort(((Remark)r.getAnnotation()).sort()).build()).collect(Collectors.toList());
            Workbook workbook = POIUtil.creatExcel((POIUtil.VERSION)this.version(), (SheetData[])new SheetData[]{SheetData.builder().setCells(cellInfos).build()});
            return new ExcelFile(this.fileName(), workbook);
        }
    }

    default public String fileName() {
        return "\u4e0b\u8f7d\u6587\u4ef6";
    }

    default public String templatePath() throws NoSuchFileException {
        throw new NoSuchFileException("\u672a\u914d\u7f6e\u6a21\u677f\u6587\u4ef6\u76ee\u5f55");
    }

    default public POIUtil.VERSION version() {
        return POIUtil.VERSION.V2007;
    }
}

