/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.service;

import cloud.agileframework.abstractbusiness.controller.BaseBusinessService;
import cloud.agileframework.abstractbusiness.pojo.EntityExistsException;
import cloud.agileframework.abstractbusiness.pojo.entity.IBaseEntity;
import cloud.agileframework.abstractbusiness.pojo.vo.BaseInParamVo;
import cloud.agileframework.abstractbusiness.pojo.vo.IBaseOutParamVo;
import cloud.agileframework.abstractbusiness.service.BaseService;
import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.data.common.dao.BaseDao;
import cloud.agileframework.dictionary.AbstractDictionaryDataManager;
import cloud.agileframework.dictionary.DictionaryDataBase;
import cloud.agileframework.dictionary.util.DictionaryUtil;
import cloud.agileframework.jpa.dao.Dao;
import cloud.agileframework.mvc.annotation.NotAPI;
import cloud.agileframework.mvc.exception.AgileArgumentException;
import cloud.agileframework.spring.util.BeanUtil;
import cloud.agileframework.spring.util.ServletUtil;
import cloud.agileframework.validate.ValidateMsg;
import cloud.agileframework.validate.ValidateUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.springframework.core.ResolvableType;

public interface IBaseService<E extends IBaseEntity, I extends BaseInParamVo, O extends IBaseOutParamVo>
extends BaseService {
    @Override
    @NotAPI
    default public BaseDao dao() {
        return (BaseDao)BeanUtil.getBean(Dao.class);
    }

    @NotAPI
    default public void validate(Object pojo, Class<?> ... groups) throws AgileArgumentException {
        List list = ValidateUtil.validate((Object)pojo, (Class[])groups);
        if (!list.isEmpty()) {
            ServletUtil.getCurrentRequest().setAttribute("$cloud.agileframework.attributeError", (Object)list);
            throw new AgileArgumentException();
        }
    }

    @NotAPI
    default public void validateEntity(Object pojo, Class<?> ... groups) throws AgileArgumentException {
        List<ValidateMsg> list = BaseBusinessService.toValidateMessages(pojo, groups);
        if (!list.isEmpty()) {
            ServletUtil.getCurrentRequest().setAttribute("$cloud.agileframework.attributeError", list);
            throw new AgileArgumentException();
        }
    }

    @NotAPI
    default public <A> void validateEntityExists(A pojo) throws EntityExistsException, AgileArgumentException {
        Dao dao = (Dao)BeanUtil.getBean(Dao.class);
        Object id = null;
        if (pojo != null) {
            id = dao.getId(pojo);
        }
        if (pojo == null || id == null) {
            ServletUtil.getCurrentRequest().setAttribute("$cloud.agileframework.attributeError", Collections.singleton(new ValidateMsg("\u4e3b\u952e\u4e0d\u5141\u8bb8\u4e3a\u7a7a", dao.getIdField(this.getEntityClass()).getName(), null)));
            throw new AgileArgumentException();
        }
        List old = dao.findAllByArrayId(pojo.getClass(), new Object[]{id});
        if (old == null || old.isEmpty()) {
            throw new EntityExistsException(id + "");
        }
    }

    @NotAPI
    default public BaseService service() {
        return (BaseService)BeanUtil.getBean(BaseService.class);
    }

    @NotAPI
    default public Class<E> getEntityClass() {
        Type entityClass = ClassUtil.getGeneric(this.getClass(), IBaseService.class, (int)0);
        if (entityClass instanceof Class) {
            return (Class)entityClass;
        }
        throw new ClassCastException("\u5f53\u524d\u7c7b\u4f5c\u4e3a\u53c2\u6570\u5316\u7c7b\u578b\u201cE\u201d\uff0c\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53\u7c7b\u578b");
    }

    @NotAPI
    default public Class<O> getOutVoClass() {
        Type outVo = ClassUtil.getGeneric(this.getClass(), IBaseService.class, (int)2);
        if (outVo instanceof Class) {
            return (Class)outVo;
        }
        throw new ClassCastException("\u5f53\u524d\u7c7b\u4f5c\u4e3a\u53c2\u6570\u5316\u7c7b\u578b\u201cO\u201d\uff0c\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53\u7c7b\u578b");
    }

    @NotAPI
    default public Class<I> getInVoClass() {
        Type inVo = ClassUtil.getGeneric(this.getClass(), IBaseService.class, (int)1);
        if (inVo instanceof Class) {
            return (Class)inVo;
        }
        throw new ClassCastException("\u5f53\u524d\u7c7b\u4f5c\u4e3a\u53c2\u6570\u5316\u7c7b\u578b\u201cI\u201d\uff0c\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53\u7c7b\u578b");
    }

    @NotAPI
    default public List<O> toOutVo(List<?> list) {
        return list.stream().map(this::toSingleOutVo).collect(Collectors.toList());
    }

    @NotAPI
    default public O toSingleOutVo(Object n) {
        if (n == null) {
            return null;
        }
        TypeReference typeReference = new TypeReference(this.getOutVoClass());
        IBaseOutParamVo o = (IBaseOutParamVo)ObjectUtil.to((Object)n, (TypeReference)typeReference);
        if (o == null) {
            return (O)((IBaseOutParamVo)ClassUtil.newInstance(this.getOutVoClass()));
        }
        DictionaryUtil.cover((Object)o);
        return (O)o;
    }

    default public AbstractDictionaryDataManager<DictionaryDataBase> dataManager() {
        if (!DictionaryDataBase.class.isAssignableFrom(this.getEntityClass())) {
            return null;
        }
        TypeReference<AbstractDictionaryDataManager<DictionaryDataBase>> typeReference = new TypeReference<AbstractDictionaryDataManager<DictionaryDataBase>>(){};
        ParameterizedType parameterizedType = (ParameterizedType)typeReference.getType();
        parameterizedType = TypeUtils.parameterizeWithOwner((Type)parameterizedType.getOwnerType(), (Class)((Class)parameterizedType.getRawType()), (Type[])new Type[]{this.getEntityClass()});
        typeReference.replace((Type)parameterizedType);
        return (AbstractDictionaryDataManager)BeanUtil.getApplicationContext().getBeanProvider(ResolvableType.forType((Type)typeReference.getType())).getIfUnique();
    }
}

