/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.controller;

import cloud.agileframework.abstractbusiness.controller.BaseBusinessService;
import cloud.agileframework.abstractbusiness.pojo.EntityExistsException;
import cloud.agileframework.abstractbusiness.pojo.entity.IBaseEntity;
import cloud.agileframework.abstractbusiness.pojo.vo.IBaseOutParamVo;
import cloud.agileframework.abstractbusiness.service.BaseService;
import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.dictionary.util.DictionaryUtil;
import cloud.agileframework.jpa.dao.Dao;
import cloud.agileframework.mvc.exception.AgileArgumentException;
import cloud.agileframework.spring.util.BeanUtil;
import cloud.agileframework.spring.util.ServletUtil;
import cloud.agileframework.validate.ValidateMsg;
import cloud.agileframework.validate.ValidateUtil;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;

public interface IBaseController<E extends IBaseEntity, O extends IBaseOutParamVo> {
    default public void validate(Object pojo, Class<?> ... groups) throws AgileArgumentException {
        List list = ValidateUtil.validate((Object)pojo, (Class[])groups);
        if (!list.isEmpty()) {
            ServletUtil.getCurrentRequest().setAttribute("$cloud.agileframework.attributeError", (Object)list);
            throw new AgileArgumentException();
        }
    }

    default public void validateEntity(Object pojo, Class<?> ... groups) throws AgileArgumentException {
        List<ValidateMsg> list = BaseBusinessService.toValidateMessages(pojo, groups);
        if (!list.isEmpty()) {
            ServletUtil.getCurrentRequest().setAttribute("$cloud.agileframework.attributeError", list);
            throw new AgileArgumentException();
        }
    }

    default public <A> void validateEntityExists(A pojo) throws EntityExistsException {
        Dao dao = (Dao)BeanUtil.getBean(Dao.class);
        Object id = dao.getId(pojo);
        List old = dao.findAllByArrayId(pojo.getClass(), new Object[]{id});
        if (old == null || old.isEmpty()) {
            throw new EntityExistsException(id + "");
        }
    }

    default public BaseService service() {
        return (BaseService)BeanUtil.getBean(BaseService.class);
    }

    default public Class<E> getEntityClass() {
        Type entityClass = ClassUtil.getGeneric(this.getClass(), IBaseController.class, (int)0);
        if (entityClass instanceof Class) {
            return (Class)entityClass;
        }
        throw new ClassCastException("\u5f53\u524d\u7c7b\u4f5c\u4e3a\u53c2\u6570\u5316\u7c7b\u578b\u201cE\u201d\uff0c\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53\u7c7b\u578b");
    }

    default public Class<O> getOutVoClass() {
        Type entityClass = ClassUtil.getGeneric(this.getClass(), IBaseController.class, (int)1);
        if (entityClass instanceof Class) {
            return (Class)entityClass;
        }
        throw new ClassCastException("\u5f53\u524d\u7c7b\u4f5c\u4e3a\u53c2\u6570\u5316\u7c7b\u578b\u201cO\u201d\uff0c\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53\u7c7b\u578b");
    }

    default public List<O> toOutVo(List<?> list) {
        return list.stream().map(this::toSingleOutVo).collect(Collectors.toList());
    }

    default public O toSingleOutVo(Object n) {
        if (n == null) {
            return null;
        }
        TypeReference typeReference = new TypeReference(this.getOutVoClass());
        IBaseOutParamVo o = (IBaseOutParamVo)ObjectUtil.to((Object)n, (TypeReference)typeReference);
        if (o == null) {
            return (O)((IBaseOutParamVo)ClassUtil.newInstance(this.getOutVoClass()));
        }
        DictionaryUtil.cover((Object)o);
        return (O)o;
    }
}

