/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.service;

import cloud.agileframework.abstractbusiness.pojo.entity.IBaseEntity;
import cloud.agileframework.abstractbusiness.pojo.vo.BaseInParamVo;
import cloud.agileframework.abstractbusiness.pojo.vo.IBaseOutParamVo;
import cloud.agileframework.abstractbusiness.service.IBaseService;
import cloud.agileframework.mvc.annotation.AgileInParam;
import cloud.agileframework.mvc.annotation.Mapping;
import cloud.agileframework.mvc.base.RETURN;
import cloud.agileframework.validate.annotation.Validate;
import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMethod;

public interface IBaseDeleteService<E extends IBaseEntity, I extends BaseInParamVo, O extends IBaseOutParamVo>
extends IBaseService<E, I, O> {
    public static final String ID = "id";

    @Validate(value="id", nullable=false)
    @Mapping(value={"${agile.base-service.deleteById:/{id}}"}, method={RequestMethod.DELETE})
    default public RETURN delete(@PathVariable(value="id") String id) {
        if (this.dataManager() != null) {
            this.dataManager().sync().deleteById(id);
            return RETURN.SUCCESS;
        }
        this.deleteById(id, this.getEntityClass());
        return RETURN.SUCCESS;
    }

    @Validate(nullable=false)
    @Mapping(value={"${agile.base-service.deleteByIds:}"}, method={RequestMethod.DELETE})
    default public RETURN delete(@AgileInParam(value="id") List<String> ids) {
        if (this.dataManager() != null) {
            for (String id : ids) {
                this.delete(id);
            }
            return RETURN.SUCCESS;
        }
        this.deleteByIds(ids, this.getEntityClass());
        return RETURN.SUCCESS;
    }

    @Mapping(value={"${agile.base-service.clean:/all}"}, method={RequestMethod.DELETE})
    default public RETURN clean() {
        if (this.dataManager() != null) {
            return RETURN.FAIL;
        }
        this.clean(this.getEntityClass());
        return RETURN.SUCCESS;
    }
}

