/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.service;

import cloud.agileframework.abstractbusiness.pojo.entity.IBaseEntity;
import cloud.agileframework.abstractbusiness.pojo.vo.BaseInParamVo;
import cloud.agileframework.abstractbusiness.service.ISecurityService;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.collection.SortInfo;
import cloud.agileframework.common.util.collection.TreeBase;
import cloud.agileframework.common.util.collection.TreeUtil;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.data.common.dao.BaseDao;
import cloud.agileframework.mvc.annotation.NotAPI;
import cloud.agileframework.spring.util.BeanUtil;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;

public interface BaseService {
    @NotAPI
    default public BaseDao dao() {
        return (BaseDao)BeanUtil.getBean(BaseDao.class);
    }

    @NotAPI
    default public ISecurityService security() {
        return (ISecurityService)BeanUtil.getBean(ISecurityService.class);
    }

    @NotAPI
    @Transactional(rollbackFor={Exception.class})
    default public <A> void saveData(List<A> data) throws NoSuchFieldException, IllegalAccessException {
        for (A node : data) {
            Object v = this.dao().getId(node);
            if (StringUtils.isBlank((CharSequence)String.valueOf(v))) {
                this.dao().setId(node, null);
            }
            if (!(node instanceof IBaseEntity) || ((IBaseEntity)node).getCreateUser() != null) continue;
            ((IBaseEntity)node).setCreateUser(this.security().currentUser());
        }
        this.dao().save(data);
    }

    @NotAPI
    @Transactional(rollbackFor={Exception.class})
    default public <A> A saveData(A data) {
        if (data instanceof Class) {
            throw new RuntimeException("not extract data of " + data);
        }
        try {
            Object v = this.dao().getId(data);
            if (StringUtils.isBlank((CharSequence)String.valueOf(v))) {
                this.dao().setId(data, null);
            }
            if (data instanceof IBaseEntity && ((IBaseEntity)data).getCreateUser() == null) {
                ((IBaseEntity)data).setCreateUser(this.security().currentUser());
            }
            return (A)this.dao().saveAndReturn(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotAPI
    @Transactional(rollbackFor={Exception.class})
    default public boolean deleteById(Object id, Class<?> javaType) {
        return this.dao().deleteById(javaType, id);
    }

    @NotAPI
    @Transactional(rollbackFor={Exception.class})
    default public boolean deleteByIds(List<String> id, Class<?> javaType) {
        try {
            this.dao().deleteInBatch(javaType, id);
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    @NotAPI
    @Transactional(rollbackFor={Exception.class})
    default public <A> A updateData(A data) {
        if (data instanceof Class) {
            throw new RuntimeException("not extract data of " + data);
        }
        if (data instanceof IBaseEntity && ((IBaseEntity)data).getUpdateUser() == null) {
            ((IBaseEntity)data).setUpdateUser(this.security().currentUser());
        }
        return (A)this.dao().updateOfNotNull(data);
    }

    @NotAPI
    default public <I extends BaseInParamVo> List<?> list(Class<?> entityClass, I inParam) {
        Object data = ObjectUtil.to(inParam, (TypeReference)new TypeReference(entityClass));
        if (data == null) {
            return this.dao().findAllByClass(entityClass, this.toSort(inParam));
        }
        return this.dao().findAll(data, this.toSort(inParam));
    }

    @NotAPI
    default public <I extends BaseInParamVo, V> List<V> list(Class<V> outVoClass, I inParam, String sql) {
        if (inParam == null) {
            return this.dao().findBySQL(sql, outVoClass, new Object[]{Maps.newHashMap()});
        }
        return this.dao().findBySQL(sql, outVoClass, new Object[]{inParam});
    }

    @NotAPI
    default public <I extends BaseInParamVo> Sort toSort(I inParam) {
        if (inParam == null) {
            return Sort.unsorted();
        }
        List<SortInfo> sorts = inParam.getSortColumn();
        if (sorts == null) {
            return Sort.unsorted();
        }
        List s = sorts.stream().map(sortInfo -> {
            if (sortInfo.isSort()) {
                return Sort.Order.desc((String)sortInfo.getProperty());
            }
            return Sort.Order.asc((String)sortInfo.getProperty());
        }).collect(Collectors.toList());
        return Sort.by(s);
    }

    @NotAPI
    default public Object queryById(Class<?> data, Object id) {
        return this.dao().findOne(data, id);
    }

    @NotAPI
    default public <V, E> V queryOne(Class<V> outVoClass, Class<E> doClass, String id, String sql) throws NoSuchFieldException {
        HashMap params = Maps.newHashMap();
        params.put(this.dao().getIdField(doClass).getName(), id);
        params.put("id", id);
        return (V)this.dao().findOne(sql, outVoClass, new Object[]{params});
    }

    @NotAPI
    default public <I extends BaseInParamVo, V> Page<V> page(Class<V> outVoClass, I inParam, String sql) {
        PageRequest pageRequest = PageRequest.of((int)(inParam.getPageNum() - 1), (int)inParam.getPageSize(), (Sort)this.toSort(inParam));
        return this.dao().pageBySQL(sql, pageRequest, outVoClass, new Object[]{inParam});
    }

    @NotAPI
    default public <I extends BaseInParamVo, E> Page<E> page(Class<E> entityClass, I inParam) {
        Object data = ObjectUtil.to(inParam, (TypeReference)new TypeReference(entityClass));
        PageRequest pageRequest = PageRequest.of((int)(inParam.getPageNum() - 1), (int)inParam.getPageSize(), (Sort)this.toSort(inParam));
        if (data == null) {
            return this.dao().pageByClass(entityClass, pageRequest);
        }
        return this.dao().page(data, pageRequest);
    }

    @NotAPI
    @Transactional(rollbackFor={Exception.class})
    default public void clean(Class<?> data) {
        this.dao().deleteAllInBatch(data);
    }

    @NotAPI
    default public <I extends Serializable, A extends TreeBase<I, A>> SortedSet<A> tree(List<A> all, I rootParentId) {
        return TreeUtil.createTree(all, rootParentId, null, (String[])new String[0]);
    }
}

