/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.service;

import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.jpa.dao.Dao;
import cloud.agileframework.mvc.annotation.AgileService;
import cloud.agileframework.mvc.annotation.Mapping;
import cloud.agileframework.mvc.exception.NoSuchRequestServiceException;
import cloud.agileframework.mvc.param.AgileParam;
import cloud.agileframework.spring.util.BeanUtil;
import cloud.agileframework.validate.ValidateCustomBusiness;
import cloud.agileframework.validate.ValidateMsg;
import cloud.agileframework.validate.ValidateUtil;
import cloud.agileframework.validate.annotation.Validate;
import cloud.agileframework.validate.annotation.Validates;
import cloud.agileframework.validate.group.Insert;
import cloud.agileframework.validate.group.Update;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.persistence.metamodel.EntityType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.RequestMethod;

@AgileService
@Mapping(value={"/${agile.module-name:api}/{model}/default"})
public class BaseService {
    @Autowired
    private Dao dao;
    private static final String SORT_COLUMN = "sorts";

    @Validate(customBusiness={InsertValidateDo.class})
    @Mapping(method={RequestMethod.POST})
    public void save(String model) throws NoSuchRequestServiceException {
        BaseService.dataAsParam(model, data -> {
            if (data instanceof Class) {
                throw new RuntimeException("not extract data of " + data);
            }
            this.dao.save(data);
            return true;
        });
    }

    private static <T> T dataAsParam(String model, Function<Object, T> function) throws NoSuchRequestServiceException {
        return (T)BaseService.typeAsParam(model, javaType -> {
            Object data = AgileParam.getInParam((Class)javaType);
            if (data == null) {
                return function.apply(javaType);
            }
            return function.apply(data);
        });
    }

    private static <T> T typeAsParam(String model, Function<Class<?>, T> function) throws NoSuchRequestServiceException {
        Optional<EntityType<?>> entityType = BaseService.getEntityType(model);
        if (entityType.isPresent()) {
            Class javaType = entityType.get().getJavaType();
            return function.apply(javaType);
        }
        throw new NoSuchRequestServiceException();
    }

    @Validate(value="id", nullable=false, isBlank=false)
    @Mapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public void delete(String model, Object id) throws NoSuchRequestServiceException {
        BaseService.typeAsParam(model, javaType -> this.dao.deleteById(javaType, id));
    }

    @Validate(value="id", nullable=false, isBlank=false)
    @Mapping(method={RequestMethod.DELETE})
    public void delete(Object[] id, String model) throws NoSuchRequestServiceException {
        BaseService.typeAsParam(model, javaType -> {
            this.dao.deleteInBatch(javaType, id);
            return true;
        });
    }

    @Validate(customBusiness={UpdateValidateDo.class})
    @Mapping(method={RequestMethod.PUT})
    public void update(String model) throws NoSuchRequestServiceException {
        BaseService.dataAsParam(model, data -> {
            if (data instanceof Class) {
                throw new RuntimeException("not extract data of " + data);
            }
            return this.dao.saveOrUpdate(data);
        });
    }

    @Mapping(method={RequestMethod.GET})
    public List<Object> query(String model) throws NoSuchRequestServiceException {
        return BaseService.dataAsParam(model, data -> {
            if (data instanceof Class) {
                return this.dao.findAllByClass((Class)data);
            }
            return this.dao.findAll(data);
        });
    }

    @Validate(value="id", nullable=false, isBlank=false)
    @Mapping(value={"/{id}"}, method={RequestMethod.GET})
    public Object queryById(String model, Object id) throws NoSuchRequestServiceException {
        return BaseService.typeAsParam(model, data -> this.dao.findOne(data, id));
    }

    @Validates(value={@Validate(value="page", nullable=false, isBlank=false), @Validate(value="size", nullable=false, isBlank=false)})
    @Mapping(value={"/{page}/{size}"}, method={RequestMethod.GET})
    public Page<Class<?>> page(String model, int page, int size) throws NoSuchRequestServiceException {
        return BaseService.typeAsParam(model, data -> this.dao.page(data, this.getPageRequest(page, size)));
    }

    private PageRequest getPageRequest(int page, int size) {
        return PageRequest.of((int)(page - 1), (int)size, (Sort)this.getSort());
    }

    private Sort getSort() {
        Sort sort = Sort.unsorted();
        if (AgileParam.containsKey((String)SORT_COLUMN)) {
            List columns = AgileParam.getInParamOfArray((String)SORT_COLUMN);
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>(columns.size());
            for (String column : columns) {
                if (column.startsWith("-")) {
                    orders.add(new Sort.Order(Sort.Direction.DESC, column));
                    continue;
                }
                orders.add(new Sort.Order(Sort.Direction.ASC, column));
            }
            sort = Sort.by(orders);
        }
        return sort;
    }

    private static Optional<EntityType<?>> getEntityType(String model) {
        Dao dao = (Dao)BeanUtil.getBean(Dao.class);
        if (dao == null) {
            throw new RuntimeException("not found Dao bean");
        }
        return dao.getEntityManager().getEntityManagerFactory().getMetamodel().getEntities().stream().filter(n -> n.getName().equalsIgnoreCase(StringUtil.toUpperName((String)model))).findFirst();
    }

    public static class UpdateValidateDo
    implements ValidateCustomBusiness {
        public List<ValidateMsg> validate(Object params) {
            String model = (String)AgileParam.getInParam((String)"model", String.class);
            try {
                return (List)BaseService.dataAsParam(model, data -> {
                    if (data instanceof Class) {
                        return null;
                    }
                    return ValidateUtil.validate((Object)data, (Class[])new Class[]{Update.class});
                });
            }
            catch (NoSuchRequestServiceException e) {
                return new ArrayList<ValidateMsg>(0);
            }
        }
    }

    public static class InsertValidateDo
    implements ValidateCustomBusiness {
        public List<ValidateMsg> validate(Object params) {
            String model = (String)AgileParam.getInParam((String)"model", String.class);
            try {
                return (List)BaseService.dataAsParam(model, data -> {
                    if (data instanceof Class) {
                        return null;
                    }
                    return ValidateUtil.validate((Object)data, (Class[])new Class[]{Insert.class});
                });
            }
            catch (NoSuchRequestServiceException e) {
                return new ArrayList<ValidateMsg>(0);
            }
        }
    }
}

