/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.controller;

import cloud.agileframework.abstractbusiness.pojo.vo.BaseInParamVo;
import cloud.agileframework.abstractbusiness.service.BaseService;
import cloud.agileframework.mvc.annotation.AgileInParam;
import cloud.agileframework.mvc.annotation.AgileService;
import cloud.agileframework.mvc.annotation.Mapping;
import cloud.agileframework.mvc.base.RETURN;
import cloud.agileframework.mvc.exception.NoSuchRequestServiceException;
import cloud.agileframework.mvc.param.AgileParam;
import cloud.agileframework.mvc.param.AgileReturn;
import cloud.agileframework.validate.ValidateCustomBusiness;
import cloud.agileframework.validate.ValidateMsg;
import cloud.agileframework.validate.ValidateUtil;
import cloud.agileframework.validate.annotation.Validate;
import cloud.agileframework.validate.annotation.Validates;
import cloud.agileframework.validate.group.Insert;
import cloud.agileframework.validate.group.Update;
import java.util.ArrayList;
import java.util.List;
import javax.validation.groups.Default;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMethod;

@AgileService
@Mapping(value={"${agile.base-service.rootPath:${agile.module-name:api}/{model}/default}"})
public class BaseBusinessService {
    public static final String MODEL = "model";
    @Autowired
    private BaseService baseService;

    @Validate(customBusiness={InsertValidateDo.class})
    @Mapping(value={"${agile.base-service.save:}"}, method={RequestMethod.POST})
    public RETURN save(@AgileInParam(value="model") String model) {
        this.baseService.save(model);
        return RETURN.SUCCESS;
    }

    @Validate(value="id", nullable=false)
    @Mapping(value={"${agile.base-service.deleteById:/{id}}"}, method={RequestMethod.DELETE})
    public RETURN delete(@AgileInParam(value="model") String model, @AgileInParam(value="id") String id) {
        this.baseService.delete(model, (Object)id);
        return RETURN.SUCCESS;
    }

    @Validate(nullable=false)
    @Mapping(value={"${agile.base-service.deleteByIds:}"}, method={RequestMethod.DELETE})
    public RETURN delete(@AgileInParam(value="model") String model, @AgileInParam List<String> ids) {
        this.baseService.delete(ids, model);
        return RETURN.SUCCESS;
    }

    @Mapping(value={"${agile.base-service.clean:/all}"}, method={RequestMethod.DELETE})
    public RETURN clean(@AgileInParam(value="model") String model) {
        this.baseService.clean(model);
        return RETURN.SUCCESS;
    }

    @Validate(customBusiness={UpdateValidateDo.class})
    @Mapping(value={"${agile.base-service.update:}"}, method={RequestMethod.PUT})
    public RETURN update(@AgileInParam(value="model") String model) {
        this.baseService.update(model);
        return RETURN.SUCCESS;
    }

    @Mapping(value={"${agile.base-service.query:/list}"}, method={RequestMethod.POST})
    public RETURN list(@AgileInParam(value="model") String model, @AgileInParam BaseInParamVo inParam) {
        AgileReturn.add((String)"result", this.baseService.list(model, inParam));
        return RETURN.SUCCESS;
    }

    @Validates(value={@Validate(value="pageNum", nullable=false), @Validate(value="pageSize", nullable=false)})
    @Mapping(value={"${agile.base-service.page:/{pageNum}/{pageSize}}"}, method={RequestMethod.POST})
    public RETURN page(@AgileInParam(value="model") String model, @AgileInParam BaseInParamVo inParam) {
        AgileReturn.add((String)"result", this.baseService.page(model, inParam));
        return RETURN.SUCCESS;
    }

    @Mapping(value={"${agile.base-service.tree:/tree}"})
    public RETURN tree(@AgileInParam(value="model") String model) {
        AgileReturn.add((String)"result", (Object)this.baseService.tree(model));
        return RETURN.SUCCESS;
    }

    @Validate(value="id", nullable=false)
    @Mapping(value={"${agile.base-service.queryById:/{id}}"}, method={RequestMethod.GET})
    public Object queryById(@AgileInParam(value="model") String model, Object id) throws NoSuchRequestServiceException {
        AgileReturn.add((String)"result", (Object)this.baseService.queryById(model, id));
        return RETURN.SUCCESS;
    }

    public static class UpdateValidateDo
    implements ValidateCustomBusiness {
        public List<ValidateMsg> validate(Object params) {
            String model = (String)AgileParam.getInParam((String)BaseBusinessService.MODEL, String.class);
            try {
                return BaseService.dataAsParam(model, data -> {
                    if (data instanceof Class) {
                        return null;
                    }
                    return ValidateUtil.validate((Object)data, (Class[])new Class[]{Default.class, Update.class});
                });
            }
            catch (NoSuchRequestServiceException e) {
                return new ArrayList<ValidateMsg>(0);
            }
        }
    }

    public static class InsertValidateDo
    implements ValidateCustomBusiness {
        public List<ValidateMsg> validate(Object params) {
            String model = (String)AgileParam.getInParam((String)BaseBusinessService.MODEL, String.class);
            try {
                return BaseService.dataAsParam(model, data -> {
                    if (data instanceof Class) {
                        return null;
                    }
                    return ValidateUtil.validate((Object)data, (Class[])new Class[]{Default.class, Insert.class});
                });
            }
            catch (NoSuchRequestServiceException e) {
                return new ArrayList<ValidateMsg>(0);
            }
        }
    }
}

