/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.service;

import cloud.agileframework.abstractbusiness.pojo.entity.IBaseEntity;
import cloud.agileframework.abstractbusiness.pojo.vo.BaseInParamVo;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.collection.SortInfo;
import cloud.agileframework.common.util.collection.TreeBase;
import cloud.agileframework.common.util.collection.TreeUtil;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.jpa.dao.Dao;
import cloud.agileframework.mvc.annotation.AgileInParam;
import cloud.agileframework.mvc.exception.NoSuchRequestServiceException;
import cloud.agileframework.mvc.param.AgileParam;
import cloud.agileframework.security.filter.login.CustomerUserDetails;
import cloud.agileframework.spring.util.BeanUtil;
import cloud.agileframework.spring.util.SecurityUtil;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.metamodel.EntityType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BaseService {
    @Autowired
    private Dao dao;
    @Value(value="${agile.base-service.tree.root-id:-1}")
    private String root;

    @Transactional(rollbackFor={Exception.class})
    public void save(String model) throws NoSuchRequestServiceException {
        BaseService.dataAsParam(model, this::saveData);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveData(Object data) {
        if (data instanceof Class) {
            throw new RuntimeException("not extract data of " + data);
        }
        try {
            UserDetails user;
            Object v = this.dao.getId(data);
            if (StringUtils.isBlank((CharSequence)String.valueOf(v))) {
                this.dao.setId(data, null);
            }
            if (data instanceof IBaseEntity && ((IBaseEntity)data).getCreateUserId() == null && (user = SecurityUtil.currentUser()) instanceof CustomerUserDetails) {
                ((IBaseEntity)data).setCreateUserId(((CustomerUserDetails)user).id());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dao.save(data);
        return true;
    }

    public static <T> T dataAsParam(String model, Function<Object, T> function) throws NoSuchRequestServiceException {
        return (T)BaseService.typeAsParam(model, javaType -> {
            Object data = AgileParam.getInParam((Class)javaType);
            if (data == null) {
                return function.apply(javaType);
            }
            return function.apply(data);
        });
    }

    private static <T> T typeAsParam(String model, Function<Class<?>, T> function) throws NoSuchRequestServiceException {
        Optional<EntityType<?>> entityType = BaseService.getEntityType(model);
        if (entityType.isPresent()) {
            Class javaType = entityType.get().getJavaType();
            return function.apply(javaType);
        }
        throw new NoSuchRequestServiceException();
    }

    private static void typeAsParam2(String model, Consumer<Class<?>> consumer) throws NoSuchRequestServiceException {
        Optional<EntityType<?>> entityType = BaseService.getEntityType(model);
        if (entityType.isPresent()) {
            Class javaType = entityType.get().getJavaType();
            consumer.accept(javaType);
            return;
        }
        throw new NoSuchRequestServiceException();
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(String model, Object id) throws NoSuchRequestServiceException {
        BaseService.typeAsParam(model, javaType -> this.deleteById(id, (Class<?>)javaType));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean deleteById(Object id, Class<?> javaType) {
        return this.dao.deleteById(javaType, id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(@AgileInParam List<String> id, String model) throws NoSuchRequestServiceException {
        BaseService.typeAsParam(model, javaType -> this.deleteByIds(id, (Class<?>)javaType));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean deleteByIds(List<String> id, Class<?> javaType) {
        this.dao.deleteInBatch(javaType, id);
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(String model) throws NoSuchRequestServiceException {
        BaseService.dataAsParam(model, this::updateData);
    }

    @Transactional(rollbackFor={Exception.class})
    public Object updateData(Object data) {
        UserDetails user;
        if (data instanceof Class) {
            throw new RuntimeException("not extract data of " + data);
        }
        if (data instanceof IBaseEntity && ((IBaseEntity)data).getUpdateUserId() == null && (user = SecurityUtil.currentUser()) instanceof CustomerUserDetails) {
            ((IBaseEntity)data).setUpdateUserId(((CustomerUserDetails)user).id());
        }
        return this.dao.saveOrUpdate(data);
    }

    public <I extends BaseInParamVo> List<Object> list(String model, I inParam) throws NoSuchRequestServiceException {
        return BaseService.dataAsParam(model, data -> {
            if (data instanceof Class) {
                return this.dao.findAllByClass((Class)data, this.toSort(inParam));
            }
            return this.dao.findAll(data, this.toSort(inParam));
        });
    }

    public <I extends BaseInParamVo> List<?> list(Class<?> entityClass, I inParam) {
        Object data = ObjectUtil.to(inParam, (TypeReference)new TypeReference(entityClass));
        if (data == null) {
            return this.dao.findAllByClass(entityClass, this.toSort(inParam));
        }
        return this.dao.findAll(data, this.toSort(inParam));
    }

    <I extends BaseInParamVo> Sort toSort(I inParam) {
        if (inParam == null) {
            return Sort.unsorted();
        }
        List<SortInfo> sorts = inParam.getSortColumn();
        if (sorts == null) {
            return Sort.unsorted();
        }
        List s = sorts.stream().map(sortInfo -> {
            if (sortInfo.isSort()) {
                return Sort.Order.desc((String)sortInfo.getProperty());
            }
            return Sort.Order.asc((String)sortInfo.getProperty());
        }).collect(Collectors.toList());
        return Sort.by(s);
    }

    public Object queryById(String model, Object id) throws NoSuchRequestServiceException {
        return BaseService.typeAsParam(model, data -> this.queryById((Class<?>)data, id));
    }

    public Object queryById(Class<?> data, Object id) {
        return this.dao.findOne(data, id);
    }

    public <I extends BaseInParamVo> Page<Object> page(String model, I inParam) throws NoSuchRequestServiceException {
        return BaseService.typeAsParam(model, data -> {
            PageRequest pageRequest = PageRequest.of((int)(inParam.getPageNum() - 1), (int)inParam.getPageSize(), (Sort)this.toSort(inParam));
            Object dto = AgileParam.getInParam((Class)data);
            if (dto != null) {
                return this.dao.page(dto, pageRequest);
            }
            return this.dao.page(data, pageRequest);
        });
    }

    public <I extends BaseInParamVo> Page<?> page(Class<?> entityClass, I inParam) {
        Object data = ObjectUtil.to(inParam, (TypeReference)new TypeReference(entityClass));
        PageRequest pageRequest = PageRequest.of((int)(inParam.getPageNum() - 1), (int)inParam.getPageSize(), (Sort)this.toSort(inParam));
        if (data == null) {
            return this.dao.page(entityClass, pageRequest);
        }
        return this.dao.page(data, pageRequest);
    }

    @Transactional(rollbackFor={Exception.class})
    public void clean(String model) throws NoSuchRequestServiceException {
        BaseService.typeAsParam2(model, this::clean);
    }

    @Transactional(rollbackFor={Exception.class})
    public void clean(Class<?> data) {
        this.dao.deleteAllInBatch(data);
    }

    public Object tree(String model) throws NoSuchRequestServiceException {
        return BaseService.dataAsParam(model, data -> {
            List all = data instanceof Class && TreeBase.class.isAssignableFrom((Class)data) ? this.dao.findAllByClass((Class)data) : (data != null && TreeBase.class.isAssignableFrom(data.getClass()) ? this.dao.findAll(data) : Lists.newArrayList());
            try {
                return TreeUtil.createTree((List)all, (String)"id", (String)"parentId", (String)"children", (String)"sort", (String)this.root, null, (String[])new String[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return Lists.newArrayList();
            }
        });
    }

    public List<?> tree(List<? extends TreeBase> all) {
        try {
            return TreeUtil.createTree(all, (String)"id", (String)"parentId", (String)"children", (String)"sort", (String)this.root, null, (String[])new String[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return Lists.newArrayList();
        }
    }

    private static Optional<EntityType<?>> getEntityType(String model) {
        Dao dao = (Dao)BeanUtil.getBean(Dao.class);
        if (dao == null) {
            throw new RuntimeException("not found Dao bean");
        }
        return dao.getEntityManager().getEntityManagerFactory().getMetamodel().getEntities().stream().filter(n -> n.getName().equalsIgnoreCase(StringUtil.toUpperName((String)model))).findFirst();
    }
}

