/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.abstractbusiness.controller;

import cloud.agileframework.abstractbusiness.controller.IBaseController;
import cloud.agileframework.abstractbusiness.pojo.entity.IBaseEntity;
import cloud.agileframework.abstractbusiness.pojo.vo.BaseInParamVo;
import cloud.agileframework.abstractbusiness.pojo.vo.IBaseOutParamVo;
import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.collection.TreeBase;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.mvc.annotation.AgileInParam;
import cloud.agileframework.mvc.base.RETURN;
import cloud.agileframework.mvc.exception.NoSuchRequestServiceException;
import cloud.agileframework.mvc.param.AgileReturn;
import cloud.agileframework.validate.annotation.Validate;
import cloud.agileframework.validate.annotation.Validates;
import cloud.agileframework.validate.group.PageQuery;
import cloud.agileframework.validate.group.Query;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public interface IBaseQueryController<E extends IBaseEntity, I extends BaseInParamVo, O extends IBaseOutParamVo>
extends IBaseController<E, O> {
    @PostMapping(value={"${agile.base-service.query:/list}"})
    default public RETURN list(@AgileInParam I inParam) {
        this.validate(inParam, Query.class);
        List list = this.service().list(this.getEntityClass(), inParam);
        List<Object> result = this.toOutVo(list);
        AgileReturn.add((String)"result", result);
        return RETURN.SUCCESS;
    }

    default public List<Object> toOutVo(List<?> list) {
        return list.stream().map(this::toSingleOutVo).collect(Collectors.toList());
    }

    default public Object toSingleOutVo(Object n) {
        TypeReference typeReference = new TypeReference(this.getOutVoClass());
        Object o = ObjectUtil.to((Object)n, (TypeReference)typeReference);
        if (o == null) {
            return ClassUtil.newInstance(this.getOutVoClass());
        }
        return o;
    }

    @Validates(value={@Validate(value="pageNum", nullable=false), @Validate(value="pageSize", nullable=false)})
    @PostMapping(value={"${agile.base-service.page:/{pageNum}/{pageSize}}"})
    default public RETURN page(@AgileInParam I inParam) {
        this.validate(inParam, PageQuery.class);
        Page page = this.service().page(this.getEntityClass(), inParam);
        PageImpl result = new PageImpl(this.toOutVo(page.getContent()), page.getPageable(), page.getTotalElements());
        AgileReturn.add((String)"result", (Object)result);
        return RETURN.SUCCESS;
    }

    @RequestMapping(value={"${agile.base-service.tree:/tree}"}, method={RequestMethod.GET, RequestMethod.POST})
    default public RETURN tree(@AgileInParam I inParam) {
        if (!TreeBase.class.isAssignableFrom(this.getEntityClass())) {
            throw new NoSuchRequestServiceException();
        }
        this.validate(inParam, Query.class);
        List list = this.service().list(this.getEntityClass(), inParam);
        if (!TreeBase.class.isAssignableFrom(this.getOutVoClass())) {
            throw new RuntimeException("your out vo class must is TreeBase subclass");
        }
        List<Object> result = this.toOutVo(list);
        AgileReturn.add((String)"result", this.service().tree(result));
        return RETURN.SUCCESS;
    }

    @Validate(value="id", nullable=false)
    @GetMapping(value={"${agile.base-service.queryById:/{id}}"})
    default public RETURN queryById(@AgileInParam(value="id") String id) {
        Object result = this.service().queryById(this.getEntityClass(), (Object)id);
        AgileReturn.add((String)"result", (Object)this.toSingleOutVo(result));
        return RETURN.SUCCESS;
    }
}

