/*
 * Decompiled with CFR 0.152.
 */
package church.i18n.processing.validation;

import church.i18n.processing.exception.ProcessingException;
import church.i18n.processing.exception.ProcessingExceptionBuilder;
import church.i18n.processing.exception.ProcessingExceptionOptionalBuilder;
import church.i18n.processing.message.ContextInfo;
import church.i18n.processing.message.ContextInfoBuilder;
import church.i18n.processing.message.ContextInfoDefaultBuilder;
import church.i18n.processing.message.ContextValue;
import church.i18n.processing.message.I18nMessage;
import church.i18n.processing.message.ProcessingMessage;
import church.i18n.processing.message.ProcessingMessageBuilder;
import church.i18n.processing.message.ProcessingMessageOptionalBuilder;
import church.i18n.processing.validation.ValidatorBuilder;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ValidatorDefaultBuilder
implements ValidatorBuilder {
    ValidatorDefaultBuilder() {
    }

    @Override
    @NotNull
    public ProcessingMessageBuilder<Optional<ProcessingMessage>> buildProcessingMessage(@NotNull String code, Object ... params) {
        return new ProcessingMessageOptionalBuilder(code, params);
    }

    @Override
    @NotNull
    public ProcessingMessageBuilder<Optional<ProcessingMessage>> buildProcessingMessage(@NotNull I18nMessage message) {
        return new ProcessingMessageOptionalBuilder(message);
    }

    @Override
    @NotNull
    public ContextInfoBuilder buildContextInfo(@NotNull String name) {
        return new ContextInfoDefaultBuilder(name);
    }

    @Override
    @NotNull
    public ProcessingExceptionBuilder buildException(@NotNull String code, Object ... params) {
        return new ProcessingExceptionOptionalBuilder(code, params);
    }

    @Override
    @NotNull
    public ProcessingExceptionBuilder buildException(@NotNull ProcessingMessage message) {
        return new ProcessingExceptionOptionalBuilder(message);
    }

    @Override
    @NotNull
    public ProcessingExceptionBuilder buildException(@NotNull ProcessingMessage message, @NotNull Throwable cause) {
        return new ProcessingExceptionOptionalBuilder(message, cause);
    }

    @Override
    @NotNull
    public Optional<ContextInfo> createContextInfo(@NotNull String name, @Nullable ContextValue context) {
        return Optional.ofNullable((ContextInfo)new ContextInfoDefaultBuilder(name).withContext(context).build());
    }

    @Override
    @NotNull
    public Optional<ContextInfo> createContextInfo(@NotNull String name, @Nullable ContextValue context, @Nullable I18nMessage message) {
        return Optional.ofNullable((ContextInfo)new ContextInfoDefaultBuilder(name).withContext(context).withMessage(message).build());
    }

    @Override
    @NotNull
    public Optional<ProcessingException> createException(@NotNull String code, Object ... params) {
        return Optional.of(new ProcessingException(code, params));
    }

    @Override
    @NotNull
    public Optional<ProcessingException> createException(@NotNull ProcessingMessage message) {
        return Optional.of(new ProcessingException(message));
    }

    @Override
    @NotNull
    public Optional<ProcessingException> createException(@NotNull ProcessingMessage message, @NotNull Throwable cause) {
        return Optional.of(new ProcessingException(message, cause));
    }

    @Override
    @NotNull
    public Optional<ProcessingMessage> createMessage(@NotNull String code, Object ... params) {
        return Optional.of(new ProcessingMessage(code, params));
    }

    @Override
    @NotNull
    public Optional<ProcessingMessage> createMessage(@NotNull I18nMessage message) {
        return Optional.of(new ProcessingMessage(message));
    }

    @Override
    public void throwException(@NotNull String code, Object ... params) {
        this.buildException(code, params).throwException();
    }

    @Override
    public void throwException(@NotNull ProcessingMessage message) {
        this.buildException(message).throwException();
    }

    @Override
    public void throwException(@NotNull ProcessingMessage message, @NotNull Throwable cause) {
        this.buildException(message, cause).throwException();
    }

    @Override
    public void throwException(@NotNull ProcessingException exception) {
        throw exception;
    }

    @NotNull
    public String toString() {
        return "ValidatorDefaultBuilder{}";
    }
}

