/*
 * Decompiled with CFR 0.152.
 */
package church.i18n.processing.security.sanitizer;

import church.i18n.processing.config.ProcessingExceptionConfig;
import church.i18n.processing.security.policy.SecurityPolicy;
import church.i18n.processing.security.sanitizer.SecurityInfoSanitizer;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultSecurityInfoSanitizer
implements SecurityInfoSanitizer {
    @NotNull
    private final Function<ProcessingExceptionConfig, SecurityPolicy> defaultSecurityPolicy;
    @NotNull
    private final Function<ProcessingExceptionConfig, Set<SecurityPolicy>> securityPolicies;

    public DefaultSecurityInfoSanitizer(@NotNull Function<ProcessingExceptionConfig, SecurityPolicy> defaultSecurityPolicy, @NotNull Function<ProcessingExceptionConfig, Set<SecurityPolicy>> securityPolicies) {
        this.defaultSecurityPolicy = defaultSecurityPolicy;
        this.securityPolicies = securityPolicies;
    }

    @Override
    public boolean canPublish(@Nullable SecurityPolicy infoSecurityPolicy, @NotNull ProcessingExceptionConfig config) {
        SecurityPolicy policyToCheck = Objects.requireNonNullElseGet(infoSecurityPolicy, () -> this.defaultSecurityPolicy.apply(config));
        return this.securityPolicies.apply(config).contains(policyToCheck);
    }
}

