/*
 * Decompiled with CFR 0.152.
 */
package church.i18n.processing.security.policy;

import church.i18n.processing.security.policy.SecurityPolicy;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public enum SecurityLevel implements SecurityPolicy
{
    PUBLIC,
    SYSTEM_EXTERNAL,
    SYSTEM_INTERNAL,
    THIRD_PARTY,
    PERSONAL_INFORMATION,
    CONFIDENTIAL,
    RESTRICTED;


    @NotNull
    public static SecurityLevel[] parse(String ... values) {
        if (values == null) {
            return new SecurityLevel[0];
        }
        Map levelMap = Arrays.stream(SecurityLevel.values()).collect(Collectors.toUnmodifiableMap(l -> l.name().toUpperCase(), Function.identity()));
        return (SecurityLevel[])Arrays.stream(values).filter(Objects::nonNull).map(String::toUpperCase).map(levelMap::get).filter(Objects::nonNull).toArray(SecurityLevel[]::new);
    }
}

