/*
 * Decompiled with CFR 0.152.
 */
package church.i18n.processing.message;

import church.i18n.processing.message.ContextInfo;
import church.i18n.processing.message.DefaultMessageType;
import church.i18n.processing.message.I18nMessage;
import church.i18n.processing.message.MessageType;
import church.i18n.processing.message.ProcessingMessage;
import church.i18n.processing.message.ProcessingMessageBuilderMethods;
import church.i18n.processing.security.policy.SecurityLevel;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessingMessageAbstractBuilder<T extends ProcessingMessageBuilderMethods<T>>
implements ProcessingMessageBuilderMethods<T> {
    private static final Logger log = LoggerFactory.getLogger(ProcessingMessageAbstractBuilder.class);
    @NotNull
    protected final I18nMessage message;
    @NotNull
    protected final List<ContextInfo> contextInfo = new ArrayList<ContextInfo>();
    @Nullable
    protected URI helpUri;
    @NotNull
    protected MessageType messageType = DefaultMessageType.DEFAULT;
    @Nullable
    protected SecurityLevel securityLevel;

    public ProcessingMessageAbstractBuilder(@NotNull String code, Object ... params) {
        this.message = new I18nMessage(code, params);
    }

    public ProcessingMessageAbstractBuilder(@NotNull I18nMessage message) {
        this.message = message;
    }

    public ProcessingMessageAbstractBuilder(@NotNull ProcessingMessage processingMessage) {
        this.message = processingMessage.getMessage();
        this.helpUri = processingMessage.getHelpUri();
        this.messageType = processingMessage.getMessageType();
        this.securityLevel = processingMessage.getSecurityLevel();
        this.contextInfo.addAll(processingMessage.getContextInfo());
    }

    @Override
    @NotNull
    public T addContextInfo(@Nullable List<ContextInfo> contextInfo) {
        if (contextInfo != null) {
            this.contextInfo.addAll(contextInfo);
        }
        return (T)this;
    }

    @Override
    @NotNull
    public T addContextInfo(ContextInfo ... contextInfo) {
        if (contextInfo != null) {
            Arrays.stream(contextInfo).filter(Objects::nonNull).forEach(this.contextInfo::add);
        }
        return (T)this;
    }

    @Override
    @NotNull
    public T withHelpUri(@Nullable URI helpUri) {
        this.helpUri = helpUri;
        return (T)this;
    }

    @Override
    @NotNull
    public T withHelpUri(@NotNull String helpUri) {
        try {
            this.helpUri = new URI(helpUri);
        }
        catch (URISyntaxException e) {
            log.error("String '{}' could not be parsed as a URI reference.", (Object)helpUri, (Object)e);
        }
        return (T)this;
    }

    @Override
    @NotNull
    public T withSecurityLevel(@Nullable SecurityLevel securityLevel) {
        this.securityLevel = securityLevel;
        return (T)this;
    }

    @Override
    @NotNull
    public T withMessageType(@NotNull MessageType messageType) {
        this.messageType = messageType;
        return (T)this;
    }

    public int hashCode() {
        return Objects.hash(this.message, this.contextInfo, this.helpUri, this.messageType, this.securityLevel);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProcessingMessageAbstractBuilder)) {
            return false;
        }
        ProcessingMessageAbstractBuilder that = (ProcessingMessageAbstractBuilder)o;
        return this.message.equals(that.message) && this.contextInfo.equals(that.contextInfo) && Objects.equals(this.helpUri, that.helpUri) && Objects.equals(this.messageType, that.messageType) && this.securityLevel == that.securityLevel;
    }

    @NotNull
    public String toString() {
        return "ProcessingMessageAbstractBuilder{message=" + String.valueOf(this.message) + ", helpUri=" + String.valueOf(this.helpUri) + ", messageType=" + String.valueOf(this.messageType) + ", contextInfo=" + String.valueOf(this.contextInfo) + ", securityLevel=" + String.valueOf(this.securityLevel) + "}";
    }
}

