/*
 * Decompiled with CFR 0.152.
 */
package church.i18n.processing.message;

import church.i18n.processing.message.ContextInfo;
import church.i18n.processing.message.DefaultMessageType;
import church.i18n.processing.message.I18nMessage;
import church.i18n.processing.message.MessageType;
import church.i18n.processing.message.ProcessingMessageBuilder;
import church.i18n.processing.message.ProcessingMessageDefaultBuilder;
import church.i18n.processing.security.policy.SecurityLevel;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessingMessage
implements Serializable {
    private static final long serialVersionUID = 7475226882356640829L;
    @NotNull
    private final I18nMessage message;
    @Nullable
    private final URI helpUri;
    @NotNull
    private final MessageType messageType;
    @NotNull
    private final List<ContextInfo> contextInfo;
    @Nullable
    private final SecurityLevel securityLevel;

    public ProcessingMessage(@NotNull String code, Object ... params) {
        this(new I18nMessage(code, params));
    }

    public ProcessingMessage(@NotNull I18nMessage message) {
        this(message, null, DefaultMessageType.DEFAULT, List.of(), null);
    }

    public ProcessingMessage(@NotNull I18nMessage message, @Nullable URI helpUri, @NotNull MessageType messageType, @NotNull List<ContextInfo> contextInfo, @Nullable SecurityLevel securityLevel) {
        this.message = message;
        this.helpUri = helpUri;
        this.messageType = messageType;
        this.contextInfo = contextInfo;
        this.securityLevel = securityLevel;
    }

    @NotNull
    public static ProcessingMessageBuilder<ProcessingMessage> withMessage(@NotNull String code, Object ... params) {
        return new ProcessingMessageDefaultBuilder(code, params);
    }

    @NotNull
    public static ProcessingMessageBuilder<ProcessingMessage> withMessage(@NotNull I18nMessage message) {
        return new ProcessingMessageDefaultBuilder(message);
    }

    @NotNull
    public static ProcessingMessageBuilder<ProcessingMessage> withMessage(@NotNull ProcessingMessage message) {
        return new ProcessingMessageDefaultBuilder(message);
    }

    @NotNull
    public List<ContextInfo> getContextInfo() {
        return this.contextInfo;
    }

    @Nullable
    public URI getHelpUri() {
        return this.helpUri;
    }

    @NotNull
    public I18nMessage getMessage() {
        return this.message;
    }

    @NotNull
    public MessageType getMessageType() {
        return this.messageType;
    }

    @Nullable
    public SecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    public int hashCode() {
        return Objects.hash(this.message, this.helpUri, this.messageType, this.contextInfo, this.securityLevel);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProcessingMessage)) {
            return false;
        }
        ProcessingMessage that = (ProcessingMessage)o;
        return this.message.equals(that.message) && Objects.equals(this.helpUri, that.helpUri) && this.messageType.equals(that.messageType) && this.contextInfo.equals(that.contextInfo) && this.securityLevel == that.securityLevel;
    }

    @NotNull
    public String toString() {
        return "ProcessingMessage{message=" + String.valueOf(this.message) + ", helpUri=" + String.valueOf(this.helpUri) + ", messageType=" + String.valueOf(this.messageType) + ", contextInfo=" + String.valueOf(this.contextInfo) + ", securityLevel=" + String.valueOf(this.securityLevel) + "}";
    }
}

