/*
 * Decompiled with CFR 0.152.
 */
package church.i18n.processing.message;

import church.i18n.processing.message.ContextInfo;
import church.i18n.processing.message.ContextInfoBuilder;
import church.i18n.processing.message.ContextValue;
import church.i18n.processing.message.I18nMessage;
import church.i18n.processing.message.ValueType;
import church.i18n.processing.security.policy.SecurityLevel;
import java.io.Serializable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextInfoDefaultBuilder
implements ContextInfoBuilder {
    @NotNull
    private final String name;
    @Nullable
    private ContextValue context;
    @Nullable
    private ContextValue help;
    @Nullable
    private I18nMessage message;
    @Nullable
    private SecurityLevel securityLevel;

    public ContextInfoDefaultBuilder(@NotNull String name) {
        this.name = name;
    }

    @Override
    @Nullable
    public ContextInfo build() {
        return new ContextInfo(this.name, this.context, this.help, this.message, this.securityLevel);
    }

    @Override
    @NotNull
    public ContextInfoBuilder withContext(@Nullable Serializable value, @Nullable ValueType valueType) {
        this.context = new ContextValue(value, valueType);
        return this;
    }

    @Override
    @NotNull
    public ContextInfoBuilder withContext(@Nullable Serializable value, @Nullable String valueType) {
        this.context = new ContextValue(value, valueType);
        return this;
    }

    @Override
    @NotNull
    public ContextInfoBuilder withContext(@Nullable Serializable value) {
        this.context = new ContextValue(value);
        return this;
    }

    @Override
    @NotNull
    public ContextInfoBuilder withContext(@Nullable ContextValue context) {
        this.context = context;
        return this;
    }

    @Override
    @NotNull
    public ContextInfoBuilder withHelp(@Nullable ContextValue help) {
        this.help = help;
        return this;
    }

    @Override
    @NotNull
    public ContextInfoBuilder withHelp(@Nullable Serializable help, @Nullable ValueType helpType) {
        this.help = new ContextValue(help, helpType);
        return this;
    }

    @Override
    @NotNull
    public ContextInfoBuilder withHelp(@Nullable Serializable help, @Nullable String helpType) {
        this.help = new ContextValue(help, helpType);
        return this;
    }

    @Override
    @NotNull
    public ContextInfoBuilder withHelp(@Nullable Serializable help) {
        this.help = new ContextValue(help);
        return this;
    }

    @Override
    @NotNull
    public ContextInfoBuilder withMessage(@Nullable I18nMessage message) {
        this.message = message;
        return this;
    }

    @Override
    @NotNull
    public ContextInfoBuilder withMessage(@Nullable String code, Object ... params) {
        if (code != null) {
            this.message = new I18nMessage(code, params);
        }
        return this;
    }

    @Override
    @NotNull
    public ContextInfoBuilder withSecurityLevel(@Nullable SecurityLevel securityLevel) {
        this.securityLevel = securityLevel;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.context, this.help, this.message, this.securityLevel);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextInfoDefaultBuilder that = (ContextInfoDefaultBuilder)o;
        return this.name.equals(that.name) && Objects.equals(this.context, that.context) && Objects.equals(this.help, that.help) && Objects.equals(this.message, that.message) && this.securityLevel == that.securityLevel;
    }

    @NotNull
    public String toString() {
        return "ContextInfoDefaultBuilder{name='" + this.name + "', context=" + String.valueOf(this.context) + ", help=" + String.valueOf(this.help) + ", message=" + String.valueOf(this.message) + ", securityLevel=" + String.valueOf(this.securityLevel) + "}";
    }
}

