/*
 * Decompiled with CFR 0.152.
 */
package church.i18n.processing.logger;

import church.i18n.processing.config.ProcessingExceptionConfig;
import church.i18n.processing.exception.ProcessingException;
import church.i18n.processing.logger.LogMapper;
import church.i18n.processing.message.MessageStatus;
import church.i18n.processing.message.MessageType;
import church.i18n.processing.security.sanitizer.SecurityInfoSanitizer;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageStatusLogMapper
implements LogMapper {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(MessageStatusLogMapper.class);
    @NotNull
    private final SecurityInfoSanitizer sanitizer;
    @NotNull
    private final ProcessingExceptionConfig config;

    public MessageStatusLogMapper(@NotNull SecurityInfoSanitizer sanitizer, @NotNull ProcessingExceptionConfig config) {
        this.sanitizer = sanitizer;
        this.config = config;
    }

    @Override
    public void log(@NotNull ProcessingException exception) {
        Optional<ProcessingException> sanitizedException = this.sanitizer.sanitize(exception, this.config);
        if (sanitizedException.isPresent()) {
            ProcessingException secException = sanitizedException.get();
            String loggedMessage = secException.getProcessingMessage().getMessage().getCode();
            MessageType messageType = exception.getProcessingMessage().getMessageType();
            if (messageType instanceof MessageStatus) {
                switch ((MessageStatus)messageType) {
                    case INFO: {
                        log.info(loggedMessage, (Throwable)secException);
                        return;
                    }
                    case WARNING: {
                        log.warn(loggedMessage, (Throwable)secException);
                        return;
                    }
                    case ERROR: {
                        log.error(loggedMessage, (Throwable)secException);
                        return;
                    }
                }
                log.error("The message status level '{}' is not implemented!", (Object)messageType);
                log.error(loggedMessage, (Throwable)secException);
                return;
            }
            log.error("This log mapper is unable to handle '{}' message type. Please consider to fix it.", (Object)messageType);
            log.error(loggedMessage, (Throwable)secException);
        }
    }

    @NotNull
    public String toString() {
        return "MessageStatusLogMapper{sanitizer=" + String.valueOf(this.sanitizer) + ", config=" + String.valueOf(this.config) + "}";
    }
}

