/*
 * Decompiled with CFR 0.152.
 */
package church.i18n.processing.logger;

import church.i18n.processing.config.ProcessingExceptionConfig;
import church.i18n.processing.exception.ProcessingException;
import church.i18n.processing.logger.LogMapper;
import church.i18n.processing.message.MessageSeverity;
import church.i18n.processing.message.MessageType;
import church.i18n.processing.security.sanitizer.SecurityInfoSanitizer;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSeverityLogMapper
implements LogMapper {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(MessageSeverityLogMapper.class);
    @NotNull
    private final SecurityInfoSanitizer sanitizer;
    @NotNull
    private final ProcessingExceptionConfig config;

    public MessageSeverityLogMapper(@NotNull SecurityInfoSanitizer sanitizer, @NotNull ProcessingExceptionConfig config) {
        this.sanitizer = sanitizer;
        this.config = config;
    }

    @Override
    public void log(@NotNull ProcessingException exception) {
        Optional<ProcessingException> sanitizedException = this.sanitizer.sanitize(exception, this.config);
        if (sanitizedException.isPresent()) {
            ProcessingException secException = sanitizedException.get();
            String loggedMessage = secException.getProcessingMessage().getMessage().getCode();
            MessageType messageType = secException.getProcessingMessage().getMessageType();
            if (messageType instanceof MessageSeverity) {
                switch ((MessageSeverity)messageType) {
                    case LOW: {
                        log.trace(loggedMessage, (Throwable)secException);
                        return;
                    }
                    case MINOR: {
                        log.debug(loggedMessage, (Throwable)secException);
                        return;
                    }
                    case NORMAL: {
                        log.info(loggedMessage, (Throwable)secException);
                        return;
                    }
                    case MODERATE: 
                    case HIGH: {
                        log.warn(loggedMessage, (Throwable)secException);
                        return;
                    }
                    case URGENT: 
                    case CRITICAL: {
                        log.error(loggedMessage, (Throwable)secException);
                        return;
                    }
                }
                log.error("The message severity level '{}' is not implemented!", (Object)messageType);
                log.error(loggedMessage, (Throwable)secException);
                return;
            }
            log.error("This log mapper is unable to handle '{}' message type. Please consider to fix it.", (Object)messageType);
            log.error(loggedMessage, (Throwable)exception);
        }
    }

    @NotNull
    public String toString() {
        return "MessageSeverityLogMapper{sanitizer=" + String.valueOf(this.sanitizer) + ", config=" + String.valueOf(this.config) + "}";
    }
}

