/*
 * Decompiled with CFR 0.152.
 */
package church.i18n.processing.exception;

import church.i18n.processing.exception.ProcessingException;
import church.i18n.processing.exception.ProcessingExceptionBuilder;
import church.i18n.processing.logger.LogLevel;
import church.i18n.processing.message.I18nMessage;
import church.i18n.processing.message.ProcessingMessage;
import church.i18n.processing.message.ProcessingMessageAbstractBuilder;
import church.i18n.processing.status.Status;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessingExceptionOptionalBuilder
extends ProcessingMessageAbstractBuilder<ProcessingExceptionBuilder>
implements ProcessingExceptionBuilder {
    private Status status;
    private LogLevel logLevel;
    private Throwable cause;

    public ProcessingExceptionOptionalBuilder(@NotNull String code, Object ... params) {
        super(code, params);
    }

    public ProcessingExceptionOptionalBuilder(@NotNull I18nMessage message) {
        super(message);
    }

    public ProcessingExceptionOptionalBuilder(@NotNull ProcessingMessage message) {
        super(message);
    }

    public ProcessingExceptionOptionalBuilder(@NotNull ProcessingMessage message, @NotNull Throwable cause) {
        super(message);
        this.cause = cause;
    }

    @Override
    @NotNull
    public Optional<ProcessingException> build() {
        return Optional.of(this.buildException());
    }

    @Override
    public void throwException() {
        throw this.buildException();
    }

    @Override
    @NotNull
    public ProcessingExceptionOptionalBuilder withLogLevel(@NotNull LogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    @Override
    @NotNull
    public ProcessingExceptionOptionalBuilder withStatus(@NotNull Status status) {
        this.status = status;
        return this;
    }

    @NotNull
    private ProcessingException buildException() {
        ProcessingException exception;
        ProcessingMessage pm = new ProcessingMessage(this.message, this.helpUri, this.messageType, this.contextInfo, this.securityLevel);
        ProcessingException processingException = exception = this.cause == null ? new ProcessingException(pm) : new ProcessingException(pm, this.cause);
        if (this.logLevel != null) {
            exception.withLogLevel(this.logLevel);
        }
        if (this.status != null) {
            exception.withStatus(this.status);
        }
        return exception;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.status, this.logLevel, this.cause});
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProcessingExceptionOptionalBuilder that = (ProcessingExceptionOptionalBuilder)o;
        return Objects.equals(this.status, that.status) && this.logLevel == that.logLevel && Objects.equals(this.cause, that.cause);
    }

    @Override
    @NotNull
    public String toString() {
        return "ProcessingExceptionOptionalBuilder{status=" + String.valueOf(this.status) + ", logLevel=" + String.valueOf((Object)this.logLevel) + ", cause=" + String.valueOf(this.cause) + ", message=" + String.valueOf(this.message) + ", contextInfo=" + String.valueOf(this.contextInfo) + ", helpUri=" + String.valueOf(this.helpUri) + ", messageType=" + String.valueOf(this.messageType) + ", securityLevel=" + String.valueOf(this.securityLevel) + "} " + super.toString();
    }
}

