/*
 * Decompiled with CFR 0.152.
 */
package church.i18n.processing.config;

import church.i18n.processing.config.ProcessingExceptionConfig;
import church.i18n.processing.message.MessageStatus;
import church.i18n.processing.message.MessageType;
import church.i18n.processing.message.ProcessingMessage;
import church.i18n.processing.security.policy.SecurityLevel;
import church.i18n.processing.security.policy.SecurityPolicy;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record DefaultProcessingExceptionConfig(@NotNull MessageType defaultMessageType, @NotNull SecurityPolicy defaultSecurityPolicy, @NotNull Set<SecurityPolicy> exposeSecurityPolicies, @NotNull Set<SecurityPolicy> logSecurityPolicies, @NotNull ProcessingMessage failoverProcessingMessage) implements ProcessingExceptionConfig
{
    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultProcessingExceptionConfig)) {
            return false;
        }
        DefaultProcessingExceptionConfig that = (DefaultProcessingExceptionConfig)o;
        return this.failoverProcessingMessage.equals(that.failoverProcessingMessage) && this.exposeSecurityPolicies.equals(that.exposeSecurityPolicies) && this.logSecurityPolicies.equals(that.logSecurityPolicies) && this.defaultMessageType.equals(that.defaultMessageType) && this.defaultSecurityPolicy.equals(that.defaultSecurityPolicy);
    }

    @Override
    @NotNull
    public String toString() {
        return "DefaultProcessingExceptionConfig{failoverProcessingMessage=" + String.valueOf(this.failoverProcessingMessage) + ", exposeSecurityPolicies=" + String.valueOf(this.exposeSecurityPolicies) + ", logSecurityPolicies=" + String.valueOf(this.logSecurityPolicies) + ", defaultMessageType=" + String.valueOf(this.defaultMessageType) + ", defaultSecurityPolicy=" + String.valueOf(this.defaultSecurityPolicy) + "}";
    }

    public static final class Builder {
        @NotNull
        private ProcessingMessage failoverProcessingMessage = new ProcessingMessage("err-g-1", new Object[0]);
        @NotNull
        private Set<SecurityPolicy> exposeSecurityPolicies = Set.of(SecurityLevel.PUBLIC, SecurityLevel.SYSTEM_EXTERNAL);
        @NotNull
        private Set<SecurityPolicy> logSecurityPolicies = Set.of(SecurityLevel.PUBLIC, SecurityLevel.SYSTEM_EXTERNAL, SecurityLevel.SYSTEM_INTERNAL, SecurityLevel.THIRD_PARTY);
        @NotNull
        private MessageType defaultMessageType = MessageStatus.ERROR;
        @NotNull
        private SecurityPolicy defaultSecurityPolicy = SecurityLevel.SYSTEM_INTERNAL;

        private Builder() {
        }

        @NotNull
        public Builder withFailoverProcessingMessage(@NotNull ProcessingMessage failoverProcessingMessage) {
            this.failoverProcessingMessage = failoverProcessingMessage;
            return this;
        }

        @NotNull
        public Builder withExposeSecurityPolicies(@NotNull Set<SecurityPolicy> exposeSecurityPolicies) {
            this.exposeSecurityPolicies = exposeSecurityPolicies;
            return this;
        }

        @NotNull
        public Builder withLogSecurityPolicies(@NotNull Set<SecurityPolicy> logSecurityPolicies) {
            this.logSecurityPolicies = logSecurityPolicies;
            return this;
        }

        @NotNull
        public Builder withDefaultMessageType(@NotNull MessageType defaultMessageType) {
            this.defaultMessageType = defaultMessageType;
            return this;
        }

        @NotNull
        public Builder withDefaultSecurityPolicy(@NotNull SecurityPolicy defaultSecurityPolicy) {
            this.defaultSecurityPolicy = defaultSecurityPolicy;
            return this;
        }

        @NotNull
        public DefaultProcessingExceptionConfig build() {
            return new DefaultProcessingExceptionConfig(this.defaultMessageType, this.defaultSecurityPolicy, this.exposeSecurityPolicies, this.logSecurityPolicies, this.failoverProcessingMessage);
        }
    }
}

