/*
 * Copyright (c) 2021 Juraj Jurčo
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
 * associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package church.i18n.processing.security.sanitizer;

import church.i18n.processing.config.ProcessingExceptionConfig;
import church.i18n.processing.security.policy.SecurityPolicy;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultSecurityInfoSanitizer implements SecurityInfoSanitizer {

  @NotNull
  private final Function<ProcessingExceptionConfig, SecurityPolicy> defaultSecurityPolicy;
  @NotNull
  private final Function<ProcessingExceptionConfig, Set<SecurityPolicy>> securityPolicies;

  public DefaultSecurityInfoSanitizer(
      @NotNull final Function<ProcessingExceptionConfig, SecurityPolicy> defaultSecurityPolicy,
      @NotNull final Function<ProcessingExceptionConfig, Set<SecurityPolicy>> securityPolicies) {
    this.defaultSecurityPolicy = defaultSecurityPolicy;
    this.securityPolicies = securityPolicies;
  }

  @Override
  public boolean canPublish(@Nullable final SecurityPolicy infoSecurityPolicy,
      @NotNull final ProcessingExceptionConfig config) {
    SecurityPolicy policyToCheck = Objects.requireNonNullElseGet(infoSecurityPolicy,
        () -> this.defaultSecurityPolicy.apply(config));
    return this.securityPolicies.apply(config).contains(policyToCheck);
  }
}
