/*
 * Decompiled with CFR 0.152.
 */
package church.i18n.processing.security.sanitizer;

import church.i18n.processing.config.ProcessingExceptionConfig;
import church.i18n.processing.exception.ProcessingException;
import church.i18n.processing.message.ContextInfo;
import church.i18n.processing.message.ProcessingMessage;
import church.i18n.processing.message.ProcessingMessageBuilder;
import church.i18n.processing.security.policy.SecurityPolicy;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SecurityInfoSanitizer {
    @NotNull
    default public Optional<ProcessingException> sanitize(@NotNull ProcessingException exception, @NotNull ProcessingExceptionConfig config) {
        Optional<ProcessingMessage> sanitizedMessage = this.sanitize(exception.getProcessingMessage(), config);
        return sanitizedMessage.map(message -> {
            ProcessingException processingException = new ProcessingException((ProcessingMessage)message, exception.getCause()).withLogLevel(exception.getLogLevel()).withStatus(exception.getStatus());
            processingException.setStackTrace(exception.getStackTrace());
            return processingException;
        });
    }

    @NotNull
    default public Optional<ProcessingMessage> sanitize(@Nullable ProcessingMessage message, @NotNull ProcessingExceptionConfig config) {
        if (message == null || !this.showInfo(message.getSecurityLevel(), config)) {
            return Optional.empty();
        }
        List<ContextInfo> sanitizedContext = message.getContextInfo().stream().map(contextInfo -> this.sanitize((ContextInfo)contextInfo, config)).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
        ProcessingMessage resultMessage = (ProcessingMessage)((ProcessingMessageBuilder)((ProcessingMessageBuilder)((ProcessingMessageBuilder)((ProcessingMessageBuilder)ProcessingMessage.withMessage(message.getMessage()).withSecurityLevel(message.getSecurityLevel())).withHelpUri(message.getHelpUri())).withMessageType(message.getMessageType())).addContextInfo(sanitizedContext)).build();
        return Optional.of(resultMessage);
    }

    @NotNull
    default public Optional<ContextInfo> sanitize(@Nullable ContextInfo contextInfo, @NotNull ProcessingExceptionConfig config) {
        if (contextInfo != null && this.showInfo(contextInfo.getSecurityLevel(), config)) {
            return Optional.of(contextInfo);
        }
        return Optional.empty();
    }

    public boolean showInfo(@Nullable SecurityPolicy var1, @NotNull ProcessingExceptionConfig var2);
}

