/*
 * Decompiled with CFR 0.152.
 */
package church.i18n.processing.message;

import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class I18nMessage {
    private static final long serialVersionUID = 6505163176616746180L;
    @NotNull
    private final String code;
    @Nullable
    private final Object[] messageParams;

    public I18nMessage(@NotNull String code, Object ... params) {
        this.code = code;
        this.messageParams = Objects.requireNonNullElseGet(params, () -> new Object[0]);
    }

    @NotNull
    public String getCode() {
        return this.code;
    }

    @Nullable
    public Object[] getMessageParams() {
        return this.messageParams;
    }

    public int hashCode() {
        int result = Objects.hash(this.code);
        result = 31 * result + Arrays.hashCode(this.messageParams);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof I18nMessage)) {
            return false;
        }
        I18nMessage that = (I18nMessage)obj;
        return Objects.equals(this.code, that.code) && Arrays.deepEquals(this.messageParams, that.messageParams);
    }

    @NotNull
    public String toString() {
        return "I18nMessage{code='" + this.code + "', messageParams=" + Arrays.toString(this.messageParams) + "}";
    }
}

