/*
 * Decompiled with CFR 0.152.
 */
package church.i18n.processing.logger;

import church.i18n.processing.config.ProcessingExceptionConfig;
import church.i18n.processing.exception.ProcessingException;
import church.i18n.processing.logger.LogMapper;
import church.i18n.processing.security.sanitizer.SecurityInfoSanitizer;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogLevelLogMapper
implements LogMapper {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(LogLevelLogMapper.class);
    @NotNull
    private final SecurityInfoSanitizer sanitizer;
    @NotNull
    private final ProcessingExceptionConfig config;

    public LogLevelLogMapper(@NotNull SecurityInfoSanitizer sanitizer, @NotNull ProcessingExceptionConfig config) {
        this.sanitizer = sanitizer;
        this.config = config;
    }

    @Override
    public void log(@NotNull ProcessingException exception) {
        Optional<ProcessingException> sanitizedException = this.sanitizer.sanitize(exception, this.config);
        if (sanitizedException.isPresent()) {
            ProcessingException secException = sanitizedException.get();
            String loggedMessage = secException.getProcessingMessage().getMessage().getCode();
            switch (secException.getLogLevel()) {
                case TRACE: {
                    log.trace(loggedMessage, (Throwable)secException);
                    break;
                }
                case DEBUG: {
                    log.debug(loggedMessage, (Throwable)secException);
                    break;
                }
                case INFO: {
                    log.info(loggedMessage, (Throwable)secException);
                    break;
                }
                case WARN: {
                    log.warn(loggedMessage, (Throwable)secException);
                    break;
                }
                default: {
                    log.error(loggedMessage, (Throwable)secException);
                }
            }
        }
    }

    @NotNull
    public String toString() {
        return "LogLevelLogMapper{sanitizer=" + this.sanitizer + "config=" + this.config + "}";
    }
}

